/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.exttool.util;

import com.huawei.ism.tool.base.utils.FilePathUtils;
import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import com.huawei.ism.tool.framework.platform.util.ApplicationContext;
import com.huawei.ism.tool.framework.platform.util.LanguageManager;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Locale;
import org.slf4j.Logger;

public final class FileUtil {
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(FileUtil.class);
    private static final String START_FAIL_FLAG = "startFailedMarker";
    private static final String WAIT_OPERA_FLAG = "waitingOperation";
    private static final String SCENE_FOLDER = "scene";
    private static final String SPACE = " ";
    private static final String UNDERLINE = "_";

    private FileUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static String getFileStr(File file) {
        String string;
        BufferedReader reader = null;
        FileInputStream fileinput = null;
        InputStreamReader inputReader = null;
        try {
            fileinput = new FileInputStream(file);
            inputReader = new InputStreamReader((InputStream)fileinput, "utf-8");
            reader = new BufferedReader(inputReader);
            string = reader.readLine();
        }
        catch (FileNotFoundException e) {
            LOGGER.error("cannot found lauguage config file.FileNotFoundException");
            String string2 = "";
            FileUtil.getClose(reader, fileinput, inputReader);
            return string2;
        }
        catch (IOException ex) {
            LOGGER.error("read lauguage config file error.IOException");
            String string3 = "";
            {
                catch (Throwable throwable) {
                    FileUtil.getClose(reader, fileinput, inputReader);
                    throw throwable;
                }
            }
            FileUtil.getClose(reader, fileinput, inputReader);
            return string3;
        }
        FileUtil.getClose(reader, fileinput, inputReader);
        return string;
    }

    private static void getClose(BufferedReader reader, FileInputStream fileinput, InputStreamReader inputReader) {
        if (null != reader) {
            try {
                reader.close();
            }
            catch (IOException e) {
                LOGGER.error("close lauguage config reader error IOException");
            }
        }
        if (null != inputReader) {
            try {
                inputReader.close();
            }
            catch (IOException e) {
                LOGGER.error("close lauguage config inputReader error IOException");
            }
        }
        if (null != fileinput) {
            try {
                fileinput.close();
            }
            catch (IOException e) {
                LOGGER.error("close lauguage config fileinput error IOException");
            }
        }
    }

    public static String getWaitingFilePath(String id) {
        return new StringBuffer().append(ApplicationContext.getInstance().getWorkPath()).append(File.separator).append("tools").append(File.separator).append(id).append(File.separator).append(WAIT_OPERA_FLAG).toString();
    }

    public static String getStartFailedMarkerPath(String id) {
        return new StringBuffer().append(ApplicationContext.getInstance().getWorkPath()).append(File.separator).append("tools").append(File.separator).append(id).append(File.separator).append(START_FAIL_FLAG).toString();
    }

    public static boolean checkWaitingFile(String id) {
        File file = new File(FileUtil.getWaitingFilePath(id));
        return file.exists() && !file.delete();
    }

    public static boolean checkFail(String id) {
        File file = new File(FileUtil.getStartFailedMarkerPath(id));
        return file.exists();
    }

    public static boolean checkToolCmdExists(String id) {
        StringBuffer startBuffer = new StringBuffer(ApplicationContext.getInstance().getWorkPath());
        startBuffer.append(File.separator).append("tools").append(File.separator).append(id).append(File.separator).append("tool.ini");
        return new File(startBuffer.toString()).exists();
    }

    public static String getCurrentProductDir(String productDir, String id) {
        Locale currentLanguage = LanguageManager.getInstance().getCurrentLanguage();
        String resoucePath = "";
        resoucePath = FilePathUtils.checkFile((String)productDir);
        if (null == resoucePath) {
            LOGGER.warn("Path of {} is not canonical.", (Object)id);
            return "";
        }
        File resouceFile = new File(resoucePath);
        String path = resoucePath;
        if (resouceFile.exists() && resouceFile.isDirectory()) {
            File[] fileList;
            for (File f : fileList = resouceFile.listFiles()) {
                if (!f.getName().toLowerCase(currentLanguage).equals(id.toLowerCase(currentLanguage))) continue;
                path = resoucePath + File.separator + f.getName();
            }
        }
        return path;
    }

    public static String getToolDir(String toolId) {
        return new StringBuffer().append(ApplicationContext.getInstance().getWorkPath()).append(File.separator).append("tools").append(File.separator).append(toolId).toString();
    }

    public static boolean recursiveFileDeletion(File file) {
        boolean deletionFlag = true;
        if (!file.exists()) {
            return false;
        }
        File[] subFiles = file.listFiles();
        if (null == subFiles) {
            return file.delete();
        }
        for (File aFile : subFiles) {
            if (FileUtil.recursiveFileDeletion(aFile)) continue;
            deletionFlag = false;
            break;
        }
        return deletionFlag ? file.delete() : deletionFlag;
    }

    public static String getSubSceneFilePath(String fieldId, String sceneId, String xmlName) {
        sceneId = sceneId.replace(SPACE, UNDERLINE);
        return ApplicationContext.getInstance().getWorkPath() + File.separator + SCENE_FOLDER + File.separator + fieldId + File.separator + sceneId + File.separator + xmlName;
    }
}

