/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.exttool.util;

import com.huawei.ism.tool.base.utils.StreamUtils;
import com.huawei.ism.tool.base.utils.XmlUtils;
import com.huawei.ism.tool.exttool.entity.UnsupportInfo;
import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ToolSupportCheck {
    private static final String SUPPORTXMLPATH = "/config/unsupportedTools.xml";
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(ToolSupportCheck.class);
    private static ToolSupportCheck instance = new ToolSupportCheck();
    private Map<String, UnsupportInfo> infoMap = new HashMap<String, UnsupportInfo>();

    private ToolSupportCheck() {
    }

    public static ToolSupportCheck getInstance() {
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initUnsupportList() {
        InputStream fis = null;
        Document doc = null;
        Element root = null;
        try {
            fis = ToolSupportCheck.class.getResourceAsStream(SUPPORTXMLPATH);
            doc = XmlUtils.parseDocument((InputStream)fis, (String)"utf-8");
        }
        catch (Exception e) {
            LoggerFactory.getLogger(this.getClass()).error("parse unsupport file error.", (Throwable)e);
        }
        finally {
            StreamUtils.closeStream(null, (InputStream)fis);
        }
        if (null == doc) {
            LOGGER.info("parseDocument() return null");
            return;
        }
        root = doc.getDocumentElement();
        Collection sonEls = XmlUtils.getChildren((Element)root, (String)"tool");
        for (Element son : sonEls) {
            UnsupportInfo uinfo = new UnsupportInfo();
            String id = son.getAttribute("id");
            uinfo.setToolId(id);
            uinfo.setVerBefore(son.getAttribute("versionBefore"));
            uinfo.setBoxVer(son.getAttribute("suggestedBoxVersion"));
            this.infoMap.put(id, uinfo);
        }
    }

    public UnsupportInfo checkSupportInfo(String id, String ver) {
        UnsupportInfo uinfo = this.infoMap.get(id);
        if (null == uinfo) {
            return null;
        }
        String verBefore = uinfo.getVerBefore();
        if (verBefore.compareTo(ver) > 0) {
            return uinfo;
        }
        return null;
    }
}

