/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.protocol.rest;

import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.log.ToolLoggerFactory;
import com.huawei.ism.tool.obase.utils.ApplicationContext;
import com.huawei.ism.tool.obase.utils.StringUtils;
import com.huawei.ism.tool.protocol.rest.RestConnection;
import com.huawei.ism.tool.protocol.rest.RestConnectionManager;
import com.huawei.ism.tool.protocol.rest.entity.RequestInfo;
import com.huawei.ism.tool.protocol.rest.entity.ResponseInfo;
import com.huawei.ism.tool.safe.SensitiveInfoFilter;
import com.huawei.json.JSONObject;
import java.util.Map;
import org.slf4j.Logger;

public class ContainerRestConnection
extends RestConnection {
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(ContainerRestConnection.class);
    private static final String PORT_CONNECTOR = ":";
    private static final String HTTPS_PREFIX = "https://";
    private static final String BASE_URI = "/v1/";
    private static final String BASE_URI_START_150 = "/v2/";
    private static final String SESSION_URI = "/v1/auth/token";
    public static final int REST_CONN_PORT = 25081;

    public ContainerRestConnection(DevNode devNode) {
        super(devNode);
        this.uri = this.getLoginUrl();
    }

    @Override
    public String getBaseUrl() {
        return HTTPS_PREFIX + this.devNode.getIp() + PORT_CONNECTOR + 25081 + BASE_URI;
    }

    public String getCheckAlarmBaseUrl() {
        return HTTPS_PREFIX + this.devNode.getIp() + PORT_CONNECTOR + 25081 + BASE_URI_START_150;
    }

    public String getLoginUrl() {
        return HTTPS_PREFIX + this.devNode.getIp() + PORT_CONNECTOR + 25081 + SESSION_URI;
    }

    @Override
    public void logOut() {
    }

    @Override
    public void closeSession() {
        super.closeSession();
        RestConnectionManager.releaseContainerRestConnection(this.devNode);
    }

    @Override
    protected void setLoginParam(RequestInfo req) {
        req.addParam("userName", this.getParamUserName(this.devNode.getLoginUser().getUserName()));
        req.addParam("password", this.devNode.getLoginUser().getPassword());
        req.addParam("authType", "STORAGE_SYSTEM");
        req.setHeader("Content-Type", "application/json");
    }

    String getParamUserName(String userName) {
        return this.isDomainUser(userName) ? userName.replace("domain/", "") : userName;
    }

    boolean isDomainUser(String userName) {
        return userName.startsWith("domain/") || this.devNode.getLoginUser().isDomain();
    }

    @Override
    protected void createHeader(RequestInfo req, Map headerParam) {
        req.setHeader("X-Auth-Token", this.session.getToken());
        req.setHeader("Content-Type", "application/json");
        req.setHeader("Accept-Language", ApplicationContext.getInstance().getCurrentLanguage().getLanguage());
    }

    @Override
    protected boolean checkLoginResult(ResponseInfo resp) {
        if (null == resp) {
            return false;
        }
        String content = resp.getContent();
        if (null == content || content.isEmpty()) {
            return false;
        }
        JSONObject json = new JSONObject(content);
        String errorCode = this.getJsonValue("errorCode", json);
        String token = this.getJsonValue("token", json);
        if (!StringUtils.isNULLStr(errorCode) && !errorCode.equals("0") || StringUtils.isNULLStr(token)) {
            LOGGER.info("login failed,resp={}", (Object)SensitiveInfoFilter.filter(content));
            return false;
        }
        this.session.setToken(token);
        return true;
    }

    @Override
    public boolean isNeedReLogin(ResponseInfo resp) {
        return false;
    }
}

