/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.protocol.rest;

import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.log.ToolLoggerFactory;
import com.huawei.ism.tool.obase.utils.ApplicationContext;
import com.huawei.ism.tool.obase.utils.StringUtils;
import com.huawei.ism.tool.protocol.rest.RestConnection;
import com.huawei.ism.tool.protocol.rest.RestConnectionManager;
import com.huawei.ism.tool.protocol.rest.entity.RequestInfo;
import com.huawei.ism.tool.protocol.rest.entity.ResponseInfo;
import com.huawei.json.JSONArray;
import com.huawei.json.JSONObject;
import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.IntStream;
import org.slf4j.Logger;

public class FceRestConnection
extends RestConnection {
    public static final int FCE_PORT = 443;
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(FceRestConnection.class);
    private static final String HTTPS_PREFIX = "https://";
    private static final String SESSION_URI = "/fce/login";
    private static final String STORAGE_DM_PORT = "8088";
    private static final String QUERY_STORAGE_INFO_URI = "/fce/device-manager/v1/device/info/list";
    private static final String QUERY_SYSTEM_INFO = "/fce/device-manager/v1/device/devices/overview";
    private static final String QUERY_EXTEND_SYSTEM_INFO = "/fce/device-manager/v1/device/devices/overview?chassisNum=%d";
    private static final String OEM_PROPERYIES = "system.properties";
    private static final String APP_NAME = "app.name";
    private static final String OEM = "oem";
    private static final List<String> NEED_RE_LOGIN_ERROR_CODE = Collections.unmodifiableList(Arrays.asList("04040183"));

    public FceRestConnection(DevNode devNode) {
        super(devNode);
        this.uri = HTTPS_PREFIX + devNode.getIp() + SESSION_URI;
    }

    @Override
    public String getBaseUrl() {
        return HTTPS_PREFIX + this.devNode.getIp();
    }

    public String getLoginUrl() {
        return HTTPS_PREFIX + this.devNode.getIp() + SESSION_URI;
    }

    public String getQueryStorageInfoUrl() {
        return this.getBaseUrl() + QUERY_STORAGE_INFO_URI;
    }

    public String getQuerySystemInfoUrl() {
        return this.getBaseUrl() + QUERY_SYSTEM_INFO;
    }

    public String getQueryExtendSystemInfoUrl(int chassisNum) {
        return this.getBaseUrl() + String.format(Locale.ENGLISH, QUERY_EXTEND_SYSTEM_INFO, chassisNum);
    }

    @Override
    public void logOut() {
    }

    @Override
    public void closeSession() {
        super.closeSession();
        RestConnectionManager.releaseFceConnection(this.devNode);
    }

    @Override
    protected void setLoginParam(RequestInfo req) {
        req.addParam("username", this.devNode.getLoginUser().getUserName());
        req.addParam("password", this.devNode.getLoginUser().getPassword());
        req.setHeader("Content-Type", "application/json");
    }

    @Override
    protected void createHeader(RequestInfo req, Map headerParam) {
        req.setHeader("X-Auth-Token", this.session.getToken());
        req.setHeader("Content-Type", "application/json");
        req.setHeader("Accept-Language", ApplicationContext.getInstance().getCurrentLanguage().getLanguage());
    }

    @Override
    protected boolean checkLoginResult(ResponseInfo resp) throws ToolException {
        if (resp == null) {
            return false;
        }
        LOGGER.info("check fce login result.");
        String content = resp.getContent();
        if (StringUtils.isNULLStr(content)) {
            return false;
        }
        JSONObject json = new JSONObject(content);
        String errorCode = this.getJsonValue("code", json);
        JSONObject dataContent = json.getJSONObject("data");
        JSONArray roles = dataContent.getJSONArray("roles");
        String token = this.getJsonValue("token", dataContent);
        if (!StringUtils.isNULLStr(errorCode) && !errorCode.equals("0") || StringUtils.isNULLStr(token)) {
            LOGGER.error("login failed,resp={}", (Object)content);
            return false;
        }
        if (IntStream.range(0, roles.length()).noneMatch(i -> roles.get(i).equals("OPEN_API")) && !this.isOemTool()) {
            throw new ToolException("devicemanager.layout.device.add.deviceadddialog.fce.login.role.is.not.openapi");
        }
        this.session.setToken(token);
        return true;
    }

    private boolean isOemTool() {
        File file = new File(com.huawei.ism.tool.framework.platform.util.ApplicationContext.getInstance().getPluginsCfgPath() + File.separator + OEM_PROPERYIES);
        String oemStr = "";
        if (file.exists()) {
            oemStr = ResourceUtil.getValByProper((File)file, (String)APP_NAME);
        }
        if (StringUtils.isNULLStr(oemStr)) {
            return false;
        }
        return oemStr.equals(OEM);
    }

    @Override
    public boolean isNeedReLogin(ResponseInfo resp) {
        JSONObject json;
        String code;
        String content = resp.getContent();
        if (!StringUtils.isNULLStr(content) && NEED_RE_LOGIN_ERROR_CODE.contains(code = (json = new JSONObject(content)).getStringOrDefault("code", ""))) {
            LOGGER.info("start to relogin.");
            return true;
        }
        return false;
    }
}

