/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.protocol.rest;

import com.huawei.common.devmgr.DeviceLocator;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.entity.EntityUtils;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.protocol.rest.RestConnFactory;
import com.huawei.ism.tool.protocol.rest.RestConnection;
import com.huawei.json.JSONObject;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestConnector {
    private static final Logger LOGGER = LoggerFactory.getLogger(RestConnector.class);
    private RestConnection restCon = null;
    private String uri;
    private String userName;
    private String passW;
    private String scope;
    private String sn;
    private DevNode devNode;

    public RestConnector(String uriString, String un, String password, String scope) {
        this.uri = uriString;
        this.userName = un;
        this.passW = password;
        this.scope = scope;
        this.sn = uriString.substring(uriString.lastIndexOf("rest/") + 5, uriString.lastIndexOf("/"));
        this.loginInfo2DevNode(this.sn, un, password);
    }

    public RestConnector(DevNode devNode) {
        this.devNode = devNode;
    }

    private void loginInfo2DevNode(String snTmp, String un, String password) {
        com.huawei.ism.tool.framework.pubservice.entity.DevNode dev = DeviceLocator.getDevNodeByDevSn((String)snTmp);
        this.devNode = EntityUtils.toOldDev(dev);
    }

    public String getLoginInfo() {
        HashMap<String, String> loginMap = new HashMap<String, String>();
        loginMap.put("URI", this.uri);
        loginMap.put("userName", this.userName);
        loginMap.put("password", this.passW);
        loginMap.put("scope", this.scope);
        this.passW = null;
        JSONObject json = new JSONObject(loginMap);
        return json.toString();
    }

    public RestConnection getConnection() {
        if (null == this.restCon) {
            this.restCon = this.createRestConnect(this.uri, this.devNode);
        } else if (!this.restCon.isLogin()) {
            this.reConnectThrowExpection();
        }
        return this.restCon;
    }

    private RestConnection createRestConnect(String restUri, DevNode dev) {
        RestConnection restConnection = null;
        try {
            restConnection = RestConnFactory.getRestConn(restUri, dev);
        }
        catch (ToolException e) {
            LOGGER.error("restConnection err", (Throwable)e);
        }
        return restConnection;
    }

    private void reConnectThrowExpection() {
        try {
            this.restCon.reLogin();
        }
        catch (Exception e) {
            LOGGER.error("reConnect err", (Throwable)e);
        }
    }

    public String toString() {
        return "RestConnector{scope='" + this.scope + '\'' + ", sn='" + this.sn + '\'' + '}';
    }
}

