/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.bizpack;

import com.huawei.ism.tool.bizpack.BizPackage;
import com.huawei.ism.tool.bizpack.BizPackageParser;
import com.huawei.ism.tool.bizpack.IBizPackageExtParser;
import com.huawei.ism.tool.bizpack.PackProduct;
import com.huawei.ism.tool.bizpack.wizardparse.context.BizPackageContext;
import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import java.util.List;

public final class BizPackageService {
    private static final BizPackageService INSTANCE = new BizPackageService();

    public static BizPackageService getInstance() {
        return INSTANCE;
    }

    public BizPackage getBizPackage(String devType, String devVersion) {
        List<BizPackage> pkgList = BizPackageContext.getInstance().getBizPackages();
        if (null == pkgList) {
            ToolLoggerFactory.getLogger(BizPackageService.class).info("PackageList is null");
            return null;
        }
        for (BizPackage bizPkg : pkgList) {
            List<PackProduct> packProList = bizPkg.getPackProducts();
            for (PackProduct packPro : packProList) {
                if (!packPro.containDevNode(devType, devVersion)) continue;
                return bizPkg;
            }
        }
        return null;
    }

    public List<? extends BizPackage> loadBizPackages(String path, IBizPackageExtParser extParser, Class<? extends BizPackage> pkgClass) {
        BizPackageParser parser = new BizPackageParser(pkgClass);
        parser.addExtParser(extParser);
        List<BizPackage> bizPkgList = parser.parseBizPackages(path);
        for (BizPackage bizPkg : bizPkgList) {
            for (PackProduct product : bizPkg.getPackProducts()) {
                BizPackageContext.getInstance().addProducts(product);
            }
        }
        BizPackageContext.getInstance().setBizPackages(bizPkgList);
        return bizPkgList;
    }
}

