/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.bizpack.wizardparse.entity.rest;

import com.huawei.ism.tool.bizpack.wizardparse.entity.rest.UrlFormatException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hc.client5.http.classic.methods.HttpUriRequest;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.NameValuePair;
import org.apache.hc.core5.http.message.BasicHeader;
import org.apache.hc.core5.http.message.BasicNameValuePair;

public abstract class RequestInfo {
    protected static final String DEFAULT_ENCODING = "UTF-8";
    private List<NameValuePair> params = new ArrayList<NameValuePair>();
    private Map<String, String> headers = new HashMap<String, String>();
    private String url;
    private String encoding;

    public RequestInfo(String url, String encoding) {
        this.url = url;
        this.encoding = encoding;
    }

    public RequestInfo(String url) {
        this(url, DEFAULT_ENCODING);
    }

    public String getUrl() {
        return this.url;
    }

    public void addParams(Map<String, String> para) {
        for (Map.Entry<String, String> keyVal : para.entrySet()) {
            this.addParam(keyVal.getKey(), keyVal.getValue());
        }
    }

    public void addParam(String name, String val) {
        this.params.add((NameValuePair)new BasicNameValuePair(name, val));
    }

    public HttpUriRequest toHttpUriRequest() throws UrlFormatException {
        return this.toHttpUriRequest(this.encoding);
    }

    public HttpUriRequest toHttpUriRequest(String theEncodingStr) throws UrlFormatException {
        String supportedEncoding = null;
        try {
            URLEncoder.encode("", theEncodingStr);
            supportedEncoding = theEncodingStr;
        }
        catch (UnsupportedEncodingException e) {
            supportedEncoding = DEFAULT_ENCODING;
        }
        HttpUriRequest httpUriReq = this.getHttpUriRequest(supportedEncoding);
        for (Map.Entry<String, String> header : this.headers.entrySet()) {
            BasicHeader h = new BasicHeader(header.getKey(), (Object)header.getValue());
            httpUriReq.addHeader((Header)h);
        }
        return httpUriReq;
    }

    public void setHeader(String name, String val) {
        this.headers.put(name, val);
    }

    protected abstract HttpUriRequest getHttpUriRequest(String var1) throws UrlFormatException;

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public List<NameValuePair> getParams() {
        return this.params;
    }

    public void setUrl(String url) {
        this.url = url;
    }
}

