/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.bizpack.wizardparse.task;

import com.huawei.ism.tool.bizpack.wizardparse.context.BizPackageContext;
import com.huawei.ism.tool.bizpack.wizardparse.context.JythonContext;
import com.huawei.ism.tool.bizpack.wizardparse.ui.step.doitem.DoItemStepCfg;
import com.huawei.ism.tool.bizpack.wizardparse.ui.step.doitem.DoOneCmdExecStep;
import com.huawei.ism.tool.bizpack.wizardparse.util.PackagesResource;
import com.huawei.ism.tool.framework.platform.exception.SignException;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.pyengine.engine.JythonExecuter;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DoOneCmdSettingTask
extends Thread {
    private static final Logger LOGGER = LoggerFactory.getLogger(DoOneCmdSettingTask.class);
    DoItemStepCfg cfg = null;
    private DoOneCmdExecStep step = null;
    private String doScriptPath = "";
    private JythonContext ssEnv;

    public DoOneCmdSettingTask(DoItemStepCfg cfg, DoOneCmdExecStep step, String doScriptPath) {
        this.step = step;
        this.doScriptPath = doScriptPath;
        this.cfg = cfg;
        this.ssEnv = BizPackageContext.getInstance().getJythonContext();
    }

    @Override
    public void run() {
        PackagesResource resource = BizPackageContext.getInstance().getCurBizPackage().getResUtil();
        JythonExecuter jythonExecuter = new JythonExecuter(new File(this.doScriptPath));
        this.ssEnv.getDict().put("logger", LOGGER);
        this.execOneCmdSeting(jythonExecuter, this.cfg.getScriptFile(), resource);
        this.step.fireFinish(null, 0);
    }

    private boolean execOneCmdSeting(JythonExecuter jythonExecuter, String pyFile, PackagesResource resource) {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("execute script : " + pyFile);
        }
        String pyDir = this.getScriptDir();
        String pyScriptFilePth = pyDir + File.separator + pyFile;
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Begin to execute python script file:" + pyScriptFilePth);
        }
        try {
            this.ssEnv.getDict().put("succ", false);
            this.ssEnv.getDict().put("uiObserver", this.step);
            this.ssEnv.getDict().put("curProgressPer", null);
            this.ssEnv.getDict().put("remainTime", null);
            Thread.sleep(200L);
            LOGGER.info("compile.....");
            File pyScriptFile = new File(pyScriptFilePth);
            if (!pyScriptFile.exists()) {
                this.step.fireException(new FileNotFoundException());
                LOGGER.error("jython File not found:" + pyScriptFilePth);
                return false;
            }
            jythonExecuter.compileScript(pyScriptFile);
            this.ssEnv.clearMsgData();
            this.excJython(jythonExecuter, this.cfg.getParam(), this.cfg.getAllAtributeMap());
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("execute script complete:" + pyScriptFilePth);
            }
            if (!((Boolean)this.ssEnv.getDict().get("succ")).booleanValue()) {
                LOGGER.error("script returned false.");
                return false;
            }
        }
        catch (FileNotFoundException e) {
            this.step.fireException(new FileNotFoundException("file not found."));
            LOGGER.error("execute script {} occur FileNotFoundException...", (Object)new File(pyScriptFilePth).getName());
            return false;
        }
        catch (SignException | ToolException e) {
            this.step.fireException((Exception)e);
            LOGGER.error("execute script " + pyScriptFilePth + "occur SignException...", e);
            return false;
        }
        catch (Exception e) {
            this.step.fireException(e);
            LOGGER.error("execute script " + pyScriptFilePth + "occur exception...", (Throwable)e);
            return false;
        }
        return true;
    }

    private void excJython(JythonExecuter jythonExecuter, String param, Map<String, Object> allAtributeMap) throws ToolException {
        Map<String, Object> envMap = this.ssEnv.getDict();
        for (Map.Entry<String, Object> entry : allAtributeMap.entrySet()) {
            envMap.put(entry.getKey(), entry.getValue());
        }
        if ("".equals(param.trim())) {
            LOGGER.info("param is empty");
            Object[] paramList = new Object[]{this.ssEnv.getDict()};
            jythonExecuter.invokeFunction("execute", paramList);
        } else {
            LOGGER.info("param not empty");
            jythonExecuter.invokeFunction("execute", new Object[]{this.ssEnv.getDict(), param});
        }
    }

    private String getScriptDir() {
        String packPath = BizPackageContext.getInstance().getCurBizPackage().getAbsolutPath();
        String processPath = BizPackageContext.getInstance().getCurBizWizardCfg().getId();
        StringBuilder scriptPath = new StringBuilder();
        scriptPath.append(packPath);
        scriptPath.append(File.separator);
        scriptPath.append("process");
        scriptPath.append(File.separator);
        scriptPath.append(processPath);
        scriptPath.append(File.separator);
        scriptPath.append("script");
        return scriptPath.toString();
    }
}

