/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.bizpack.wizardparse.ui.component;

import com.huawei.ism.tool.base.ui.UiMethod;
import com.huawei.ism.tool.base.ui.component.ToolHyperLinkLabel;
import com.huawei.ism.tool.bizpack.wizardparse.context.BizPackageContext;
import com.huawei.ism.tool.bizpack.wizardparse.entity.BizPackGroup;
import com.huawei.ism.tool.bizpack.wizardparse.entity.BizWizardConfig;
import com.huawei.ism.tool.bizpack.wizardparse.ui.action.WizardAction;
import com.huawei.ism.tool.bizpack.wizardparse.util.AutomateUtils;
import com.huawei.ism.tool.bizpack.wizardparse.util.PackagesResource;
import com.huawei.ism.tool.framework.platform.util.LanguageManager;
import com.huawei.ism.util.UCD;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import javax.swing.text.StyleConstants;

public class GroupTypePanel
extends JPanel {
    public static final Dimension GROUP_SIZE_PER = new Dimension(375, 150);
    public static final Dimension GROUP_SIZE_MAX = new Dimension(375, 600);
    public static final Dimension GROUP_SIZE_PER_EN = new Dimension(380, 160);
    public static final Dimension GROUP_SIZE_MAX_EN = new Dimension(380, 600);
    public static final Font TITLE_FONT_ZH = new Font("\u5b8b\u4f53", 1, 13);
    public static final Font TITLE_FONT_EN = new Font("Arail", 1, 13);
    public static final Font DESC_FONT_ZH = new Font("", 0, 12);
    public static final Font DESC_FONT_EN = new Font("Arail", 0, 12);
    public static final Dimension DESCPANE_SIZE = new Dimension(327, 60);
    public static final Dimension DESCPANE_SIZE_EN = new Dimension(327, 100);
    public static final Dimension FRU_SIZE = new Dimension(155, 20);
    public static final int NUMBER_EIGHT = 8;
    private static final long serialVersionUID = -5920380235018278829L;
    private static final float LINE_SPACE = 0.3f;
    private Locale localeLanguage = LanguageManager.getInstance().getCurrentLanguage();
    private List<ToolHyperLinkLabel> fruTitleList = new ArrayList<ToolHyperLinkLabel>();

    public GroupTypePanel(BizPackGroup group) {
        if (LanguageManager.getInstance().getCurrentLanguage().equals(Locale.ENGLISH)) {
            this.setPreferredSize(GROUP_SIZE_PER_EN);
            this.setMaximumSize(GROUP_SIZE_MAX_EN);
        } else {
            this.setPreferredSize(GROUP_SIZE_PER);
            this.setMaximumSize(GROUP_SIZE_MAX);
        }
        this.initUI(group);
    }

    private void initUI(BizPackGroup group) {
        this.setLayout(new BoxLayout(this, 0));
        PackagesResource resutil = BizPackageContext.getInstance().getCurBizPackage().getResUtil();
        this.add(UCD.buildVBoxTop((Component[])new Component[]{new JLabel(resutil.getImage(group.getIconPath()))}));
        this.add(Box.createHorizontalStrut(8));
        this.add(this.buildInfoPanel(group));
    }

    private JPanel buildInfoPanel(BizPackGroup group) {
        JPanel panel = new JPanel();
        AutomateUtils.setNameAttribute(panel, "panel_groupType");
        panel.setLayout(new BoxLayout(panel, 1));
        PackagesResource resutil = BizPackageContext.getInstance().getCurBizPackage().getResUtil();
        JLabel titleLabel = new JLabel(resutil.getString(group.getTitle()));
        UiMethod.setFont((JComponent)titleLabel, (Font)TITLE_FONT_EN, (Font)TITLE_FONT_ZH, (Locale)this.localeLanguage);
        JTextPane descPane = UiMethod.createTextPaneWithLeftIdent((String)resutil.getString(group.getDescription()), (int)0);
        UiMethod.setFont((JComponent)descPane, (Font)DESC_FONT_EN, (Font)DESC_FONT_ZH, (Locale)this.localeLanguage);
        StyleConstants.setLineSpacing(descPane.getStyle("default"), 0.3f);
        if (LanguageManager.getInstance().getCurrentLanguage().equals(Locale.ENGLISH)) {
            descPane.setPreferredSize(DESCPANE_SIZE_EN);
            descPane.setMaximumSize(DESCPANE_SIZE_EN);
        } else {
            descPane.setPreferredSize(DESCPANE_SIZE);
            descPane.setMaximumSize(DESCPANE_SIZE);
        }
        List<BizWizardConfig> wizards = group.getBizWizardCfg();
        panel.add(UCD.buildHBoxLeft((int)2, (Component[])new Component[]{new JLabel(), titleLabel}));
        panel.add(descPane);
        panel.add(this.buildItemsPanel(wizards, group));
        panel.add(Box.createVerticalStrut(30));
        return panel;
    }

    private JPanel buildItemsPanel(List<BizWizardConfig> wizards, BizPackGroup group) {
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        int count = 0;
        ToolHyperLinkLabel label = null;
        PackagesResource resutil = BizPackageContext.getInstance().getCurBizPackage().getResUtil();
        for (BizWizardConfig wizard : wizards) {
            label = new ToolHyperLinkLabel(resutil.getString(wizard.getTitle()));
            AutomateUtils.setNameAttribute((Component)label, group.getTitle() + "." + wizard.getId());
            label.addClickListener((ToolHyperLinkLabel.ClickListener)new WizardAction(wizard));
            label.setPreferredSize(FRU_SIZE);
            label.setMinimumSize(FRU_SIZE);
            gbc.gridx = count % 2;
            gbc.gridy = count / 2;
            gbc.weightx = 1.0;
            gbc.weighty = 1.0;
            gbc.fill = 2;
            gbc.anchor = 18;
            gbc.insets = new Insets(5, 4, 0, 0);
            panel.add((Component)label, gbc);
            this.fruTitleList.add(label);
            ++count;
        }
        return panel;
    }

    public List<ToolHyperLinkLabel> getFruTitleList() {
        return this.fruTitleList;
    }
}

