/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.bizpack.wizardparse.ui.component;

import com.huawei.ism.tool.base.ui.component.wizard.IHelpActionCallBack;
import com.huawei.ism.tool.base.utils.FileUtils;
import com.huawei.ism.tool.base.utils.OSCmdUtils;
import com.huawei.ism.tool.bizpack.wizardparse.context.BizPackageContext;
import com.huawei.ism.tool.framework.platform.exception.ToolException;
import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import com.huawei.ism.tool.framework.platform.util.LanguageManager;
import com.huawei.ism.tool.framework.pubservice.entity.SceneValue;
import com.huawei.ism.tool.framework.pubservice.sceneimpl.SceneEnvironmentImpl;
import java.io.File;
import javax.swing.JDialog;

public class OpenHelpCallBack
implements IHelpActionCallBack {
    private String helpName = "";
    private JDialog parentDlg = null;

    public OpenHelpCallBack(JDialog dlg, String help) {
        this.parentDlg = dlg;
        this.helpName = help;
    }

    public void doHelpActionWork() {
        this.openHelpFile(this.helpName, this.parentDlg);
    }

    public String getListenerName() {
        return "Open fru help file";
    }

    private void openHelpFile(String fileName, JDialog dlg) {
        String loc = LanguageManager.getInstance().getCurrentLanguage().getLanguage();
        String htmlFileName = fileName + "_" + loc + ".html";
        File helpFile = new File(htmlFileName);
        ToolLoggerFactory.getLogger(FileUtils.class).info("explorer help file:" + helpFile + "parnet is :" + dlg);
        if (!helpFile.exists()) {
            String chmFileName = fileName + "_" + loc + ".chm";
            File chmFile = new File(chmFileName);
            if (!chmFile.exists()) {
                ToolLoggerFactory.getLogger(FileUtils.class).error("Help file does not exit: " + helpFile.getName());
            } else {
                OSCmdUtils.openHelpFileInCHM(chmFile);
            }
        } else {
            OSCmdUtils.explorerFile(helpFile);
        }
    }

    public static String getHelpPath() {
        try {
            SceneValue sv = (SceneValue)SceneEnvironmentImpl.getInstance().getEnvirValueByKey("jsonScene");
            if (sv != null && sv.getSubScene() != null) {
                ToolLoggerFactory.getLogger(OpenHelpCallBack.class).info("processId is:" + sv.getSubScene());
                if ("Expansion Links".equals(sv.getSubScene())) {
                    return "";
                }
            }
        }
        catch (ToolException e) {
            ToolLoggerFactory.getLogger(OpenHelpCallBack.class).error("getEnvirValueByKey fail");
        }
        String bizHelpPath = BizPackageContext.getInstance().getCurBizPackage().getHelp();
        if (bizHelpPath.trim().equals("")) {
            return "";
        }
        StringBuilder help = new StringBuilder();
        help.append(BizPackageContext.getInstance().getCurBizPackage().getAbsolutPath());
        help.append(File.separator);
        help.append("res");
        help.append(File.separator);
        help.append("help");
        help.append(File.separator);
        help.append(bizHelpPath);
        return help.toString();
    }
}

