/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.bizpack.wizardparse.ui.component.info;

import com.huawei.ism.tool.bizpack.wizardparse.context.BizPackageContext;
import com.huawei.ism.tool.bizpack.wizardparse.entity.BizStepConfig;
import com.huawei.ism.tool.bizpack.wizardparse.ui.component.info.InfoItem;
import com.huawei.json.JSONObject;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPanel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InfoBoard {
    private static final Logger LOGGER = LoggerFactory.getLogger(InfoBoard.class);
    private static final int GAP_SIZE = 25;
    private static final int EXTEND_WEIGHT = 44;
    private static final int ITEM_HEIGHT = 30;
    private static final int PANEL_HEIGHT = 10;
    private static final int DOUBLE_LEN = 2;
    private static final int MAX_CHINES_NUM = 40869;
    private static final int MIN_CHINES_NUM = 19968;
    private String id = "";
    private String name = "";
    private JPanel bord;
    private List<InfoItem> refreshItems = new ArrayList<InfoItem>();

    public JPanel getRefreshBord() {
        this.bord = new JPanel();
        this.initUi(this.bord);
        return this.bord;
    }

    private void initUi(JPanel initBord) {
        initBord.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 17;
        c.fill = 0;
        int widthCount = 1;
        c.gridx = 0;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridy = 0;
        for (InfoItem item : this.refreshItems) {
            if (item.isHorizon() && c.gridx == 0) {
                c.gridwidth = 2;
                JPanel jPanel = item.getItemBord();
                initBord.add((Component)jPanel, c);
                c.gridwidth = 1;
                ++c.gridy;
                continue;
            }
            if (item.isHorizon() && c.gridx == 1) {
                c.gridwidth = 2;
                c.gridx = 0;
                ++c.gridy;
                initBord.add((Component)item.getItemBord(), c);
                c.gridwidth = 1;
                ++c.gridy;
                continue;
            }
            initBord.add((Component)item.getItemBord(), c);
            if (++widthCount % 2 != 0) {
                ++c.gridy;
                c.gridx = 0;
                continue;
            }
            ++c.gridx;
        }
    }

    public void setSize(BizStepConfig cfg) {
        try {
            Dimension wizardSize = cfg.getWizardSize();
            if (wizardSize == null) {
                wizardSize = BizPackageContext.getInstance().getCurBizWizardCfg().getWizardSize();
            }
            int wi = wizardSize.width;
            if (cfg.isNeedDeviceGraph()) {
                wi -= cfg.getDevGraphSize().width + 25;
            }
            int panelWidth = (wi - 44) * 2 / 3 + 50;
            int itemLineNum = this.refreshItems.size() / 2 + this.refreshItems.size() % 2;
            int panelHeight = itemLineNum * 30 + 10;
            this.bord.setPreferredSize(new Dimension(panelWidth, panelHeight));
        }
        catch (Exception e) {
            LOGGER.error("set size err", (Throwable)e);
        }
    }

    public void setTextData(String json, boolean needGraph) {
        JSONObject jsonObject = new JSONObject(json);
        for (InfoItem item : this.refreshItems) {
            String text = jsonObject.getString(item.getId());
            boolean isBarCode = this.isBarCode(item.getId());
            boolean isSlotName = this.isSlotName(item.getId());
            if (null == text) continue;
            boolean needSub = needGraph && text.length() > 25 || !needGraph && text.length() > 45;
            boolean needSubChinese = this.checkChinese(text) && needGraph && text.length() > 15;
            boolean needSubBarCode = isBarCode && needGraph && text.length() > 12;
            boolean needSubSlotName = isSlotName && needGraph && text.length() > 15 || isSlotName && !needGraph && text.length() > 25;
            String subText = text;
            if (needSubBarCode) {
                subText = text.substring(0, 10) + "...";
                item.setTextAndTips(subText, text);
                continue;
            }
            if (needSubSlotName) {
                subText = needGraph ? text.substring(0, 15) + "..." : text.substring(0, 23) + "...";
                item.setTextAndTips(subText, text);
                continue;
            }
            if (needSubChinese) {
                subText = text.substring(0, 14) + "...";
                item.setTextAndTips(subText, text);
                continue;
            }
            if (needSub) {
                subText = needGraph ? text.substring(0, 23) + "..." : text.substring(0, 45) + "...";
                item.setTextAndTips(subText, text);
                continue;
            }
            item.setText(subText);
        }
    }

    private boolean isBarCode(String id) {
        return "barcode".equalsIgnoreCase(id);
    }

    private boolean isSlotName(String id) {
        return "slot_name".equalsIgnoreCase(id);
    }

    public boolean checkChinese(String text) {
        char textNum = '\u0000';
        Boolean noChinese = false;
        for (int i = 0; i < text.length(); ++i) {
            textNum = text.charAt(i);
            if (textNum < '\u4e00' || textNum >= '\u9fa5') continue;
            return true;
        }
        return noChinese;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<InfoItem> getRefreshItems() {
        return this.refreshItems;
    }

    public void setRefreshItems(List<InfoItem> refreshItems) {
        this.refreshItems = refreshItems;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setBord(JPanel bord) {
        this.bord = bord;
    }
}

