/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.bizpack.wizardparse.ui.component.table;

import com.huawei.ism.tool.bizpack.wizardparse.context.BizPackageContext;
import com.huawei.ism.tool.bizpack.wizardparse.ui.component.table.TableColumn;
import com.huawei.ism.tool.bizpack.wizardparse.ui.component.table.TableData;
import com.huawei.ism.tool.bizpack.wizardparse.util.AutomateUtils;
import com.huawei.ism.tool.bizpack.wizardparse.util.PackagesResource;
import com.huawei.ism.ui.swing.table.DefaultTableModel;
import com.huawei.ism.ui.swing.table.DefaultTableRow;
import com.huawei.ism.ui.swing.table.IsmTable;
import com.huawei.ism.ui.swing.table.IsmTableCell;
import com.huawei.ism.ui.swing.table.TableRow;
import com.huawei.json.JSONArray;
import com.huawei.json.JSONObject;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.table.TableModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TableItem {
    private static final String DROP_DOWN_SIGN = "#drop-down#";
    private static final String DROP_DOWN_DEFAULT_SIGN = "#drop-default#";
    private static final Logger LOGGER = LoggerFactory.getLogger(TableItem.class);
    private String id = "";
    private String parentId = "";
    private IsmTable ismTable = null;
    private DefaultTableModel tableModel = null;
    private String[] columnNames = null;
    private int[] columnvisible;
    private List<TableColumn> columnIdList = new ArrayList<TableColumn>();
    private String name = "";
    private List<String> refreshItems = new ArrayList<String>();
    private String jsonRetData = "";
    private List<String> detailDialogIdList = new ArrayList<String>();
    private Map<String, TableColumn> id2ColCfgMap = new HashMap<String, TableColumn>();
    private boolean needSelect = true;
    private boolean needFreshForDevGraph = false;
    private boolean needMultiCheck = false;

    public TableItem(String parentId) {
        this.parentId = parentId;
        AutomateUtils.setNameAttribute((Component)this.ismTable, "ismTable");
    }

    public IsmTable getComponent() {
        this.createIsmTable(this.columnIdList);
        return this.ismTable;
    }

    public void initFresh() {
        List<Map<String, String>> datas = this.json2TableData(this.jsonRetData);
        for (Map<String, String> oneRowMap : datas) {
            TableData oneRowData = new TableData();
            oneRowData.setDataIdList(this.getColIdListOnly());
            oneRowData.setId2DataMap(oneRowMap);
            this.tableModel.addRow(new TableRow[]{this.createTableRow(oneRowData)});
            if (!"true".equals(oneRowMap.getOrDefault("marked", "false"))) continue;
            int rowNum = this.ismTable.getRowCount() - 1;
            this.ismTable.addRowSelectionInterval(rowNum, rowNum);
        }
    }

    public void init2FaultyData() {
        List<Map<String, String>> datas = this.json2TableData(this.jsonRetData);
        for (Map<String, String> oneRowMap : datas) {
            String visibleFlag = oneRowMap.get("visible");
            if (!"true".equalsIgnoreCase(visibleFlag.trim())) continue;
            TableData oneRowData = new TableData();
            oneRowData.setDataIdList(this.getColIdListOnly());
            oneRowData.setId2DataMap(oneRowMap);
            this.tableModel.addRow(new TableRow[]{this.createTableRow(oneRowData)});
            if (!"true".equals(oneRowMap.getOrDefault("marked", "false"))) continue;
            int rowNum = this.ismTable.getRowCount() - 1;
            this.ismTable.addRowSelectionInterval(rowNum, rowNum);
        }
    }

    private void createIsmTable(List<TableColumn> colIdList) {
        PackagesResource resUtil = BizPackageContext.getInstance().getCurBizPackage().getResUtil();
        this.columnIdList = colIdList;
        this.columnNames = new String[colIdList.size()];
        ArrayList<Integer> columnvisibleList = new ArrayList<Integer>();
        int i = 0;
        for (TableColumn tableColumn : colIdList) {
            String columnName;
            this.columnNames[i] = columnName = resUtil.getString(tableColumn.getName());
            if (tableColumn.isVisible()) {
                columnvisibleList.add(i);
            }
            if (tableColumn.isHasDetailDialog()) {
                this.detailDialogIdList.add(tableColumn.getId());
            }
            this.id2ColCfgMap.put(tableColumn.getId(), tableColumn);
            ++i;
        }
        int size = columnvisibleList.size();
        int j = 0;
        this.columnvisible = new int[size];
        for (Integer integer : columnvisibleList) {
            this.columnvisible[j] = integer;
            ++j;
        }
        this.tableModel = new DefaultTableModel(this.columnNames, this.columnvisible);
        this.ismTable = new IsmTable((TableModel)this.tableModel);
        this.ismTable.setSelectionMode(0);
    }

    public List<Map<String, String>> json2TableData(String json) {
        ArrayList<Map<String, String>> allTableData = new ArrayList<Map<String, String>>();
        JSONArray jsonArray = new JSONArray(json);
        for (int i = 0; i < jsonArray.length(); ++i) {
            HashMap<String, String> oneRowData = new HashMap<String, String>();
            JSONObject jsonObject = (JSONObject)jsonArray.get(i);
            Iterator it = jsonObject.keys();
            while (it.hasNext()) {
                String key = (String)it.next();
                String value = jsonObject.getString(key);
                oneRowData.put(key, value);
            }
            if (jsonObject.has("visible")) {
                oneRowData.put("visible", jsonObject.getString("visible"));
            } else {
                oneRowData.put("visible", "false");
            }
            allTableData.add(oneRowData);
        }
        return allTableData;
    }

    private TableRow<?, ?> createTableRow(TableData oneRow) {
        DefaultTableRow row = new DefaultTableRow(this.columnNames.length, (Object)oneRow, (Object)oneRow);
        List<String> dataIdList = oneRow.getDataIdList();
        Map<String, String> id2DataMap = oneRow.getId2DataMap();
        int i = 0;
        for (String strId : dataIdList) {
            String value = id2DataMap.get(strId);
            if (null == value) {
                ++i;
                continue;
            }
            if (this.isDropDownCell(value)) {
                row.setValueAt(i, (Object)this.buildDropDownCell(value, id2DataMap, strId));
            } else {
                row.setValueAt(i, (Object)value);
            }
            ++i;
        }
        return row;
    }

    private IsmTableCell buildDropDownCell(String value, Map<String, String> id2DataMap, String strId) {
        int defaultIndex = value.indexOf(DROP_DOWN_DEFAULT_SIGN);
        String dropDefault = value.substring(defaultIndex).replace(DROP_DOWN_DEFAULT_SIGN, "");
        String dropStr = value.substring(0, defaultIndex).replace(DROP_DOWN_SIGN, "");
        Object[] dropLists = dropStr.split(",");
        IsmTableCell.ComboBoxCell cell = new IsmTableCell.ComboBoxCell(dropLists, (Object)dropDefault);
        cell.setActionListener((ActionListener)new IsmComBoxTableListener(cell, id2DataMap, strId));
        return cell;
    }

    public void putAllData() {
        List rows = this.ismTable.getAllRows();
        BizPackageContext.getInstance().getJythonContext().getDict().put(this.getAllTabelItemId(), this.tableData2json(rows));
    }

    private String tableData2json(List<TableRow> rows) {
        List selectedRows = this.ismTable.getMarkedRows();
        ArrayList<JSONObject> jsonObjects = new ArrayList<JSONObject>();
        for (TableRow row : rows) {
            TableData oneRow = (TableData)row.getIdentifier();
            oneRow.getId2DataMap().remove("_self_marked");
            if (selectedRows.contains(row)) {
                oneRow.getId2DataMap().put("_self_marked", "true");
            }
            JSONObject tableData = new JSONObject(oneRow.getId2DataMap());
            jsonObjects.add(tableData);
        }
        JSONArray array = new JSONArray(jsonObjects);
        return array.toString();
    }

    public String getSelectTabelItemId() {
        StringBuilder itemId = new StringBuilder();
        itemId.append("input");
        itemId.append('_');
        itemId.append(this.getParentId());
        itemId.append('_');
        itemId.append(this.getId());
        return itemId.toString();
    }

    private String getAllTabelItemId() {
        StringBuilder itemId = new StringBuilder();
        itemId.append("allInput");
        itemId.append('_');
        itemId.append(this.getParentId());
        itemId.append('_');
        itemId.append(this.getId());
        return itemId.toString();
    }

    private boolean isDropDownCell(String value) {
        return value.trim().startsWith(DROP_DOWN_SIGN);
    }

    public List<String> getColIdListOnly() {
        ArrayList<String> colIdListOnly = new ArrayList<String>();
        for (TableColumn clo : this.columnIdList) {
            colIdListOnly.add(clo.getId());
        }
        return colIdListOnly;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public List<String> getRefreshItems() {
        return this.refreshItems;
    }

    public void setRefreshItems(List<String> refreshItems) {
        this.refreshItems = refreshItems;
    }

    public List<TableColumn> getColumnIdList() {
        return this.columnIdList;
    }

    public void setColumnIdList(List<TableColumn> columnIdList) {
        this.columnIdList = columnIdList;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public DefaultTableModel getTableModel() {
        return this.tableModel;
    }

    public void setTableModel(DefaultTableModel tableModel) {
        this.tableModel = tableModel;
    }

    public IsmTable getIsmTable() {
        return this.ismTable;
    }

    public void setIsmTable(IsmTable ismTable) {
        this.ismTable = ismTable;
    }

    public String[] getColumnNames() {
        return (String[])this.columnNames.clone();
    }

    public void setColumnNames(String[] columnNames) {
        this.columnNames = (String[])columnNames.clone();
    }

    public String getJsonRetData() {
        return this.jsonRetData;
    }

    public void setJsonRetData(String jsonRetData) {
        this.jsonRetData = jsonRetData;
    }

    public List<String> getDetailDialogIdList() {
        return this.detailDialogIdList;
    }

    public void setDetailDialogIdList(List<String> detailDialogIdList) {
        this.detailDialogIdList = detailDialogIdList;
    }

    public Map<String, TableColumn> getId2ColCfgMap() {
        return this.id2ColCfgMap;
    }

    public void setId2ColCfgMap(Map<String, TableColumn> id2ColCfgMap) {
        this.id2ColCfgMap = id2ColCfgMap;
    }

    public String getParentId() {
        return this.parentId;
    }

    public void setParentId(String parentId) {
        this.parentId = parentId;
    }

    public boolean isNeedSelect() {
        return this.needSelect;
    }

    public void setNeedSelect(boolean needSelect) {
        this.needSelect = needSelect;
    }

    public boolean isNeedFreshForDevGraph() {
        return this.needFreshForDevGraph;
    }

    public void setNeedFreshForDevGraph(boolean needFreshForDevGraph) {
        this.needFreshForDevGraph = needFreshForDevGraph;
    }

    public boolean isNeedMultiCheck() {
        return this.needMultiCheck;
    }

    public void setNeedMultiCheck(boolean needMultiCheck) {
        this.needMultiCheck = needMultiCheck;
    }

    private class IsmComBoxTableListener
    implements ActionListener {
        private IsmTableCell.ComboBoxCell cell = null;
        private Map<String, String> id2DataMap = null;
        private String strId = "";

        public IsmComBoxTableListener(IsmTableCell.ComboBoxCell cell, Map<String, String> id2DataMap, String strId) {
            this.cell = cell;
            this.id2DataMap = id2DataMap;
            this.strId = strId;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.id2DataMap.put(this.strId, String.valueOf(this.cell.getComboBox().getSelectedItem()));
            TableRow row = TableItem.this.ismTable.getMarkedRow();
            if (null == row) {
                return;
            }
            TableData oneRow = (TableData)row.getIdentifier();
            JSONObject tableData = new JSONObject(oneRow.getId2DataMap());
            BizPackageContext.getInstance().getJythonContext().getDict().put(TableItem.this.getSelectTabelItemId(), tableData.toString());
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("select table combox[" + TableItem.this.getSelectTabelItemId() + "]");
            }
        }
    }
}

