/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.bizpack.wizardparse.ui.dialog;

import com.huawei.ism.tool.base.ui.component.wizard.WizardRootPaneUI;
import com.huawei.ism.tool.bizpack.wizardparse.ui.dialog.SelectZoneDeviceDialogLayout;
import com.huawei.ism.tool.devicemanager.ui.listener.ScenePreparedMainJDialogListener;
import com.huawei.ism.tool.obase.entity.DmeNode;
import com.huawei.ism.tool.obase.ui.tablecompositer.IpAddressStrategy;
import com.huawei.ism.tool.obase.utils.CollectionUtil;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import com.huawei.ism.ui.swing.table.DefaultTableRow;
import com.huawei.ism.ui.swing.table.IsmTableCell;
import com.huawei.ism.ui.swing.table.TableRow;
import com.huawei.ism.util.SwingUtil;
import java.awt.Window;
import java.awt.event.WindowListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JDialog;
import javax.swing.plaf.RootPaneUI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SelectZoneDeviceDialog
extends JDialog {
    private static final Logger log = LoggerFactory.getLogger(SelectZoneDeviceDialog.class);
    private boolean isSingleDev;
    private SelectZoneDeviceDialogLayout mainLayout;
    private WizardRootPaneUI rootPaneUI = new WizardRootPaneUI();
    private Window parent;
    private List<DmeNode> storageDevNodeList = new ArrayList<DmeNode>();

    public SelectZoneDeviceDialog(Window parent, List<DmeNode> storageNodeList, boolean isSingleDev) {
        super(parent);
        this.parent = parent;
        this.isSingleDev = isSingleDev;
        this.initUI();
        this.initData(storageNodeList);
        this.addListener();
    }

    private void initUI() {
        this.rootPaneUI.setShowHelp(false);
        this.getRootPane().setUI((RootPaneUI)this.rootPaneUI);
        this.mainLayout = new SelectZoneDeviceDialogLayout(this.isSingleDev);
        this.add(this.mainLayout);
        this.setTitle(ResourceUtil.getString((String)"bizpack.add.zone.device.title"));
        this.setModal(true);
        this.setResizable(false);
        this.validate();
        this.pack();
        this.setDefaultCloseOperation(0);
        SwingUtil.putParentCenter((Window)this, (Window)this.parent);
    }

    private void initData(List<DmeNode> storageDevList) {
        this.mainLayout.getDeviceTable().removeAll();
        storageDevList.forEach(dev -> this.mainLayout.getDeviceTableModel().addRow(new TableRow[]{this.createTableRow((DmeNode)dev)}));
    }

    private void addListener() {
        this.addWindowListener((WindowListener)new ScenePreparedMainJDialogListener(this){

            public void okCallback() {
            }

            public void cancelCallback() {
                SelectZoneDeviceDialog.this.setDefaultCloseOperation(0);
            }
        });
        this.mainLayout.getOkBtn().addActionListener(e -> {
            this.setSelectedDevNode();
            if (this.judgeDevsIsEmpty(this.storageDevNodeList)) {
                log.info("not select controller enclosure.");
                return;
            }
            this.dispose();
        });
        this.mainLayout.getCancelBtn().addActionListener(e -> {
            log.info("click cacel btn, not select controller enclosure.");
            this.dispose();
        });
    }

    private boolean judgeDevsIsEmpty(List<DmeNode> devs) {
        if (CollectionUtil.isEmpty(devs)) {
            DialogUtils.showInfoDialog((JDialog)this, (String)ResourceUtil.getString((String)"bizpack.remind.selectnodevice"));
            return true;
        }
        return false;
    }

    private TableRow<DmeNode, String> createTableRow(DmeNode dev) {
        DefaultTableRow row = new DefaultTableRow(this.mainLayout.getTableColumn(), (Object)dev, (Object)dev.getDeviceSerialNumber());
        int rowIndex = 0;
        row.setValueAt(rowIndex++, (Object)new IsmTableCell.TextCell("zone" + dev.getUuid()));
        row.setValueAt(rowIndex++, (Object)new IsmTableCell.TextCell(new IpAddressStrategy(dev.getIp()).toString()));
        row.setValueAt(rowIndex++, (Object)new IsmTableCell.TextCell(dev.getProductModel()));
        row.setValueAt(rowIndex++, (Object)new IsmTableCell.TextCell(dev.getProductVersion()));
        return row;
    }

    public void addRelatedDevNode(DmeNode dev) {
        if (!this.storageDevNodeList.contains(dev)) {
            this.storageDevNodeList.add(dev);
        }
    }

    private void setSelectedDevNode() {
        int[] rowIndexs = this.mainLayout.getDeviceTable().getSelectedRows();
        if (rowIndexs == null || rowIndexs.length == 0) {
            return;
        }
        for (int index : rowIndexs) {
            index = this.mainLayout.getDeviceTable().convertRowIndexToModel(index);
            TableRow row = this.mainLayout.getDeviceTableModel().getRow(index);
            this.addRelatedDevNode((DmeNode)row.getUserObject());
        }
    }

    public List<DmeNode> getStorageDevNodeList() {
        return this.storageDevNodeList;
    }
}

