/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.bizpack.wizardparse.ui.dialog.waitdialog;

import com.huawei.ism.tool.bizpack.wizardparse.task.ExecPyScriptTask;
import com.huawei.ism.tool.bizpack.wizardparse.ui.dialog.waitdialog.WaitDialogResult;
import com.huawei.ism.tool.framework.platform.exception.SignException;
import java.io.FileNotFoundException;
import java.util.concurrent.Callable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetUserInputWaitDialog
implements Callable<WaitDialogResult> {
    private static final Logger LOGGER = LoggerFactory.getLogger(GetUserInputWaitDialog.class);
    private String preScriptPath = "";
    private String pyName = "";
    private String func = "";

    public GetUserInputWaitDialog(String preScriptPath, String pyName, String func) {
        this.preScriptPath = preScriptPath;
        this.pyName = pyName;
        this.func = func;
    }

    @Override
    public WaitDialogResult call() {
        WaitDialogResult result = new WaitDialogResult();
        ExecPyScriptTask preSetTask = null;
        try {
            preSetTask = new ExecPyScriptTask(this.preScriptPath, this.pyName);
            if (preSetTask.execFunc(this.func)) {
                result.setFlag(true);
                result.setTask(preSetTask);
            } else {
                result.setFlag(false);
            }
        }
        catch (FileNotFoundException e) {
            LOGGER.error("GetUserInput jython File {} not found", (Object)this.pyName);
            result.setException(new FileNotFoundException());
            result.setFlag(false);
        }
        catch (SignException e) {
            LOGGER.error("GetUserInput python file has no sign", (Throwable)e);
            result.setException(e);
            result.setFlag(false);
        }
        catch (Exception e) {
            LOGGER.error("GetUserInput jython exec err", (Throwable)e);
            result.setException(e);
            result.setFlag(false);
        }
        return result;
    }
}

