/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.bizpack.wizardparse.ui.step.connect;

import com.huawei.ism.tool.base.ui.UiMethod;
import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.bizpack.wizardparse.context.BizPackageContext;
import com.huawei.ism.tool.bizpack.wizardparse.context.JythonContext;
import com.huawei.ism.tool.bizpack.wizardparse.task.ExecPyUtils;
import com.huawei.ism.tool.bizpack.wizardparse.ui.component.guidelink.GuideLink;
import com.huawei.ism.tool.bizpack.wizardparse.ui.step.AbstractBizStepLayout;
import com.huawei.ism.tool.bizpack.wizardparse.ui.step.connect.ConnectionGuideStepCfg;
import com.huawei.ism.tool.bizpack.wizardparse.util.AutomateUtils;
import com.huawei.ism.tool.bizpack.wizardparse.util.PackagesResource;
import com.huawei.ism.util.UCD;
import com.huawei.json.JSONArray;
import com.huawei.json.JSONObject;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionGuideStepLayout
extends AbstractBizStepLayout {
    private static final long serialVersionUID = 7491515422974791916L;
    private static final Logger LOGGER = LoggerFactory.getLogger(ConnectionGuideStepLayout.class);
    private static final int WIZARD_BLANK_SIZE = 45;
    private static ImageIcon blackRec = ResourceUtil.getImage("wizard_rectangle.jpg");
    private JLabel titleDesc = new JLabel();
    private JEditorPane tailPromptPane = UiMethod.createEditorPane();
    private JCheckBox check = new JCheckBox();
    private JPanel docLinkPanel = new JPanel();
    private List<GuideLink> doclinks = new ArrayList<GuideLink>();
    private List<JCheckBox> checkBoxs = new ArrayList<JCheckBox>();

    public ConnectionGuideStepLayout(ConnectionGuideStepCfg cfg) {
        BizPackageContext.getInstance().getId2LayoutMap().put(cfg.getId(), this);
        this.initUi(cfg);
        this.setCompName();
    }

    private void setCompName() {
        AutomateUtils.setNameAttribute(this.check, "check");
        AutomateUtils.setNameAttribute(this.docLinkPanel, "docLinkPanel");
    }

    private void initUi(ConnectionGuideStepCfg cfg) {
        this.setBizCfg(cfg);
        Dimension wizardSize = cfg.getWizardSize();
        JDialog wizardDialog = BizPackageContext.getInstance().getWizard();
        if (wizardSize != null) {
            wizardDialog.setMinimumSize(wizardSize);
            wizardDialog.setPreferredSize(wizardSize);
            wizardDialog.setSize(wizardSize);
        }
        List<String> text = cfg.getCheckItem();
        String script = cfg.getScriptFile();
        boolean hasScript = false;
        if (!StringUtils.isNULLStr(script)) {
            if (!ExecPyUtils.execInitScript(script, "", "getItems")) {
                LOGGER.info("exec getItems failed.");
            } else {
                hasScript = true;
                JythonContext ssEnv = BizPackageContext.getInstance().getJythonContext();
                if (!((Boolean)ssEnv.getDict().get("succ")).booleanValue()) {
                    String errMsg = (String)ssEnv.getDict().get("errMsg");
                    LOGGER.error("init presetting step dropDown Text err." + errMsg);
                }
                String retData = (String)ssEnv.getDict().get("retData");
                text = this.getItemsByJson(retData);
            }
        }
        JComponent view = null;
        if (cfg.getGuideLinkGroup().getLinks().size() > 0) {
            cfg.getGuideLinkGroup().init(cfg);
            this.docLinkPanel = cfg.getGuideLinkGroup().getLinkPanel();
            this.doclinks = cfg.getGuideLinkGroup().getLinks();
            view = !cfg.getGuideLinkGroup().isShowInContext() ? UCD.buildVerticalBox(null, (Component[])new Component[]{UiMethod.buildCompsLeft((Component[])new Component[]{this.docLinkPanel}), UiMethod.buildCompsLeft((Component[])new Component[]{this.titleDesc}), UiMethod.buildCompsLeft((Component[])new Component[]{this.getDescLineComp(text, cfg, hasScript)}), Box.createVerticalGlue(), UiMethod.buildCompsLeft((Component[])new Component[]{this.check})}) : UCD.buildVerticalBox(null, (Component[])new Component[]{UiMethod.buildCompsLeft((Component[])new Component[]{this.titleDesc}), UiMethod.buildCompsLeft((Component[])new Component[]{this.getDescLineComp(text, cfg, hasScript)}), Box.createVerticalGlue(), UiMethod.buildCompsLeft((Component[])new Component[]{this.check})});
        } else {
            view = UCD.buildVerticalBox(null, (Component[])new Component[]{UiMethod.buildCompsLeft((Component[])new Component[]{this.titleDesc}), UiMethod.buildCompsLeft((Component[])new Component[]{this.getDescLineComp(text, cfg, hasScript)}), Box.createVerticalGlue(), UiMethod.buildCompsLeft((Component[])new Component[]{this.check})});
        }
        this.setViewInLayout(cfg, view, true);
    }

    private List<String> getItemsByJson(String json) {
        ArrayList<String> itemLists = new ArrayList<String>();
        JSONArray jsonArray = new JSONArray(json);
        for (int i = 0; i < jsonArray.length(); ++i) {
            JSONObject jsonObject = (JSONObject)jsonArray.get(i);
            String title = jsonObject.getString("title");
            itemLists.add(title);
        }
        return itemLists;
    }

    private JPanel getDescLineComp(List<String> text, ConnectionGuideStepCfg cfg, boolean hasScript) {
        PackagesResource resource = BizPackageContext.getInstance().getCurBizPackage().getResUtil();
        JPanel descPanel = null;
        descPanel = cfg.isNeedAllCheck() ? this.buildAllCheckPanel(text, resource, hasScript) : this.buildNoCheckPanel(text, resource, hasScript);
        return descPanel;
    }

    private JPanel buildAllCheckPanel(List<String> text, PackagesResource resource, boolean hasScript) {
        JPanel descPanel = new JPanel();
        descPanel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 0;
        c.anchor = 18;
        c.gridy = 0;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.insets = new Insets(5, 0, 0, 0);
        Iterator<String> iterator = text.iterator();
        while (iterator.hasNext()) {
            String info = hasScript ? iterator.next() : resource.getString(iterator.next());
            c.gridx = 0;
            c.weightx = 0.0;
            c.insets = new Insets(2, 12, 5, 0);
            c.fill = 0;
            JCheckBox box = new JCheckBox();
            this.checkBoxs.add(box);
            descPanel.add((Component)box, c);
            c.insets = new Insets(0, 8, 5, 0);
            c.gridx = 1;
            c.weightx = 1.0;
            c.fill = 2;
            this.addCheckItemDesc(descPanel, c, info);
            ++c.gridy;
        }
        c.fill = 2;
        descPanel.add((Component)this.tailPromptPane, c);
        c.weighty = 1.0;
        ++c.gridy;
        JLabel blank = new JLabel();
        descPanel.add((Component)blank, c);
        return descPanel;
    }

    private void addCheckItemDesc(JPanel descPanel, GridBagConstraints c, String info) {
        String actualInfo = info;
        for (final GuideLink link : this.doclinks) {
            String linkStr = "<a href='" + link.getLinkLabel().getName() + "'>";
            if (actualInfo.indexOf(linkStr) == -1) continue;
            JEditorPane editorPane = UiMethod.createEditorPane();
            editorPane.setMargin(new Insets(1, 0, 0, 0));
            actualInfo = actualInfo.replaceAll("(" + linkStr + "((?!</a>).)*</a>)", "<font color='#0000FF' style='text-decoration:none;' face='\u5b8b\u4f53&&arial' size='3'>$0</font>");
            editorPane.setText("<font face='\u5b8b\u4f53&&arial' size='3'>" + actualInfo + "</font>");
            editorPane.addHyperlinkListener(new HyperlinkListener(){

                @Override
                public void hyperlinkUpdate(HyperlinkEvent event) {
                    if (event.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                        link.clickLink();
                    }
                }
            });
            descPanel.add((Component)editorPane, c);
            return;
        }
        JLabel label = new JLabel();
        this.setJLabelText(label, actualInfo, 45);
        descPanel.add((Component)label, c);
    }

    private JPanel buildNoCheckPanel(List<String> text, PackagesResource resource, boolean hasScript) {
        JPanel descPanel = new JPanel();
        descPanel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 18;
        c.fill = 0;
        c.gridy = 0;
        c.weighty = 0.0;
        c.weightx = 0.0;
        c.insets = new Insets(5, 0, 0, 0);
        Iterator<String> iterator = text.iterator();
        while (iterator.hasNext()) {
            String info;
            String string = info = hasScript ? iterator.next() : resource.getString(iterator.next());
            if (!iterator.hasNext()) {
                c.weighty = 1.0;
            }
            c.weightx = 0.0;
            c.gridx = 0;
            c.insets = new Insets(5, 12, 5, 0);
            c.fill = 0;
            JLabel imgLabel = new JLabel(blackRec);
            imgLabel.setSize(blackRec.getIconWidth(), blackRec.getIconHeight());
            descPanel.add((Component)imgLabel, c);
            c.gridx = 1;
            c.weightx = 1.0;
            c.insets = new Insets(0, 8, 5, 0);
            c.fill = 2;
            this.addCheckItemDesc(descPanel, c, info);
            ++c.gridy;
        }
        JLabel blank = new JLabel();
        descPanel.add((Component)blank, c);
        return descPanel;
    }

    public JLabel getTitleDesc() {
        return this.titleDesc;
    }

    public void setTitleDesc(JLabel titleDesc) {
        this.titleDesc = titleDesc;
    }

    public JCheckBox getCheck() {
        return this.check;
    }

    public void setCheck(JCheckBox check) {
        this.check = check;
    }

    public List<JCheckBox> getCheckBoxs() {
        return this.checkBoxs;
    }

    public void setCheckBoxs(List<JCheckBox> checkBoxs) {
        this.checkBoxs = checkBoxs;
    }

    public JEditorPane getTailPromptPane() {
        return this.tailPromptPane;
    }

    public void setTailPromptPane(JEditorPane tailPromptPane) {
        this.tailPromptPane = tailPromptPane;
    }
}

