/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.bizpack.wizardparse.ui.step.exec;

import com.huawei.ism.tool.base.utils.XmlUtils;
import com.huawei.ism.tool.bizpack.wizardparse.entity.BizStepConfig;
import com.huawei.ism.tool.bizpack.wizardparse.ui.component.table.TableColumn;
import com.huawei.ism.tool.bizpack.wizardparse.ui.component.table.TableItem;
import com.huawei.ism.tool.bizpack.wizardparse.ui.step.exec.MultiExecType;
import com.huawei.ism.tool.obase.utils.StringUtils;
import java.awt.Dimension;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class MultiExecStepCfg
extends BizStepConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger(MultiExecStepCfg.class);
    private static final String MUL_TABLE = "host-table";
    private static final String MUL_COLUMN = "column";
    private static final String MUL_DIALOG_COLUMN = "dialog-column";
    private static final Dimension MUL_DEFAULT_DIALOG_SIZE = new Dimension(450, 530);
    private TableItem mulTable = new TableItem(this.getId());
    private MultiExecType mulmode = MultiExecType.CHECK;
    private String mulsignColId = "";
    private int multiNum = 1;
    private boolean enableMutiSelect = false;
    private boolean riskWarn = false;
    private boolean execOnce = false;

    @Override
    public void loadConfig(Element node) {
        Element multableNodeElement;
        String execOnceStr;
        String riskWarnStr;
        String multiNumStr;
        this.setId(this.getAttribute(node, "id", ""));
        this.setDescription(this.getAttribute(node, "desc", ""));
        this.setTitle(this.getAttribute(node, "title", ""));
        this.setScriptFile(this.getAttribute(node, "script", ""));
        this.setPrompt(this.getAttribute(node, "prompt", ""));
        this.setCancelScript(this.getAttribute(node, "cancelScript", ""));
        this.setParam(this.getAttribute(node, "param", ""));
        String mulauto = this.getAttribute(node, "auto", "");
        if (mulauto.equalsIgnoreCase("true")) {
            this.setAuto(true);
        }
        String mulbackwardStr = this.getAttribute(node, "backward", "");
        this.setBackwardValue(mulbackwardStr);
        String mulmodeName = this.getAttribute(node, "mode", "");
        if ("exec".equalsIgnoreCase(mulmodeName.trim())) {
            this.mulmode = MultiExecType.EXEC;
        }
        if (!"".equalsIgnoreCase((multiNumStr = this.getAttribute(node, "multiNum", "")).trim())) {
            this.multiNum = Integer.valueOf(multiNumStr);
        }
        if ((riskWarnStr = this.getAttribute(node, "riskWarn", "")).equalsIgnoreCase("true")) {
            this.setRiskWarn(true);
        }
        if ((execOnceStr = this.getAttribute(node, "execOnce", "")).equalsIgnoreCase("true")) {
            this.setExecOnce(true);
        }
        if ((multableNodeElement = XmlUtils.getChild(node, MUL_TABLE)) == null) {
            return;
        }
        String mulitemId = this.getAttribute(multableNodeElement, "id", "");
        String mulname = this.getAttribute(multableNodeElement, "name", "");
        String mulselect = this.getAttribute(multableNodeElement, "enableMutiSelect", "");
        this.mulTable.setId(mulitemId);
        this.mulTable.setName(mulname);
        if (mulselect.equals("true")) {
            this.setEnableMutiSelect(true);
        }
        this.loadOneTableColumn(multableNodeElement, this.mulTable);
        this.parseCommon(node);
    }

    private void loadOneTableColumn(Element node, TableItem tableItem) {
        NodeList columnList = node.getElementsByTagName(MUL_COLUMN);
        if (columnList == null || columnList.getLength() == 0) {
            return;
        }
        int tableLength = columnList.getLength();
        List<TableColumn> columnIdList = tableItem.getColumnIdList();
        for (int index = 0; index < tableLength; ++index) {
            Element nodeElement = (Element)columnList.item(index);
            String mulitemId = this.getAttribute(nodeElement, "id", "");
            String mulname = this.getAttribute(nodeElement, "name", "");
            String mulvisible = this.getAttribute(nodeElement, "visible", "");
            String mulsignKey = this.getAttribute(nodeElement, "signKey", "");
            if ("true".equalsIgnoreCase(mulsignKey.trim())) {
                this.mulsignColId = mulitemId;
            }
            String showdialog = this.getAttribute(nodeElement, "showdialog", "");
            TableColumn mulselectTableColumn = new TableColumn();
            mulselectTableColumn.setId(mulitemId);
            mulselectTableColumn.setName(mulname);
            String lengthStr = this.getAttribute(nodeElement, "length", "");
            if (!"".equals(lengthStr.trim())) {
                int length = Integer.valueOf(lengthStr);
                mulselectTableColumn.setLength(length);
            }
            if (mulvisible.trim().equalsIgnoreCase("false")) {
                mulselectTableColumn.setVisible(false);
            }
            if ("true".equals(showdialog.trim())) {
                TableItem muldetailTable = new TableItem(this.getId());
                this.loadShowDialogItem(node, muldetailTable);
                muldetailTable.setName(mulname);
                muldetailTable.setId(mulitemId);
                String mulscript = this.getAttribute(nodeElement, "script", "");
                String mulparam = this.getAttribute(node, "param", "");
                String mulsizeStr = this.getAttribute(nodeElement, "dialogsize", "");
                mulselectTableColumn.setScript(mulscript);
                mulselectTableColumn.setParam(mulparam);
                mulselectTableColumn.setHasDetailDialog(true);
                Dimension size = this.getDetailDialogSize(mulsizeStr);
                mulselectTableColumn.setDialogSize(size);
                mulselectTableColumn.setDetailDialogTable(muldetailTable);
            }
            columnIdList.add(mulselectTableColumn);
        }
    }

    private Dimension getDetailDialogSize(String mulsizeStr) {
        Dimension size = MUL_DEFAULT_DIALOG_SIZE;
        try {
            if (!StringUtils.isNULLStr((String)mulsizeStr)) {
                String[] sizeList = mulsizeStr.split(",");
                int xValue = Integer.parseInt(sizeList[0].trim());
                int yValue = Integer.parseInt(sizeList[1].trim());
                size = new Dimension(xValue, yValue);
            }
        }
        catch (Exception e) {
            LOGGER.error("Load WizardSize ERR", (Throwable)e);
        }
        return size;
    }

    private void loadShowDialogItem(Element node, TableItem detailTable) {
        NodeList mulcolumnList = node.getElementsByTagName(MUL_DIALOG_COLUMN);
        if (mulcolumnList == null || mulcolumnList.getLength() == 0) {
            return;
        }
        int tableLength = mulcolumnList.getLength();
        List<TableColumn> mulcolumnIdList = detailTable.getColumnIdList();
        for (int index = 0; index < tableLength; ++index) {
            String lengthStr;
            Element nodeElement = (Element)mulcolumnList.item(index);
            String mulitemId = this.getAttribute(nodeElement, "id", "");
            String mulname = this.getAttribute(nodeElement, "name", "");
            String mulvisible = this.getAttribute(nodeElement, "visible", "");
            TableColumn mulselectTableColumn = new TableColumn();
            mulselectTableColumn.setId(mulitemId);
            mulselectTableColumn.setName(mulname);
            if (mulvisible.trim().equalsIgnoreCase("false")) {
                mulselectTableColumn.setVisible(false);
            }
            if (!"".equals((lengthStr = this.getAttribute(nodeElement, "length", "")).trim())) {
                int length = Integer.valueOf(lengthStr);
                mulselectTableColumn.setLength(length);
            }
            mulcolumnIdList.add(mulselectTableColumn);
        }
    }

    public TableItem getIoTable() {
        return this.mulTable;
    }

    public void setIoTable(TableItem ioTable) {
        this.mulTable = ioTable;
    }

    public MultiExecType getMode() {
        return this.mulmode;
    }

    public void setMode(MultiExecType mode) {
        this.mulmode = mode;
    }

    public int getMultiNum() {
        return this.multiNum;
    }

    public void setMultiNum(int multiNum) {
        this.multiNum = multiNum;
    }

    public String getSignColId() {
        return this.mulsignColId;
    }

    public void setSignColId(String signColId) {
        this.mulsignColId = signColId;
    }

    public boolean isEnableMutiSelect() {
        return this.enableMutiSelect;
    }

    public void setEnableMutiSelect(boolean enableMutiSelect) {
        this.enableMutiSelect = enableMutiSelect;
    }

    public void setRiskWarn(boolean riskWarn) {
        this.riskWarn = riskWarn;
    }

    public boolean isRiskWarn() {
        return this.riskWarn;
    }

    public void setExecOnce(boolean execOnce) {
        this.execOnce = execOnce;
    }

    public boolean isExecOnce() {
        return this.execOnce;
    }
}

