/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.bizpack.wizardparse.ui.step.flex.comp;

import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.bizpack.wizardparse.context.BizPackageContext;
import com.huawei.ism.tool.bizpack.wizardparse.ui.step.preset.comp.IInputComponent;
import com.huawei.ism.tool.bizpack.wizardparse.ui.step.preset.comp.InputItem;
import com.huawei.ism.tool.bizpack.wizardparse.util.PackagesResource;
import com.huawei.json.JSONArray;
import com.huawei.json.JSONException;
import com.huawei.json.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ItemRow {
    private String script = "";
    private String param = "";
    private String rowKey = "";
    private List<InputItem> inputItems = new ArrayList<InputItem>();
    private Map<String, IInputComponent> compsMap = new HashMap<String, IInputComponent>();

    public ItemRow(String jsonStr) {
        PackagesResource resutil = BizPackageContext.getInstance().getCurBizPackage().getResUtil();
        this.createOneRow(resutil, jsonStr);
    }

    private void createOneRow(PackagesResource resutil, String jsonStr) throws JSONException {
        JSONObject jsonObject = new JSONObject(jsonStr);
        this.setRowKey(this.getJsonValue("id", jsonObject));
        this.setScript(this.getJsonValue("script", jsonObject));
        this.setParam(this.getJsonValue("param", jsonObject));
        JSONArray jsonArray = jsonObject.getJSONArray("columns");
        for (int i = 0; i < jsonArray.length(); ++i) {
            JSONObject itemObject = (JSONObject)jsonArray.get(i);
            InputItem inputItem = this.createInputItem(itemObject, resutil);
            this.inputItems.add(inputItem);
        }
    }

    public InputItem createInputItem(JSONObject jsonObject, PackagesResource resutil) {
        String filtStr;
        InputItem inputItem = new InputItem();
        inputItem.setId(this.getJsonValue("id", jsonObject));
        inputItem.setType(this.getJsonValue("type", jsonObject));
        String actStr = this.getJsonValue("isAct", jsonObject);
        if (actStr.equalsIgnoreCase("false")) {
            inputItem.setAct(false);
        }
        if ((filtStr = this.getJsonValue("isFilter", jsonObject)).equalsIgnoreCase("true")) {
            inputItem.setFilter(true);
        }
        JSONObject contentObject = jsonObject.getJSONObject("content");
        inputItem.setLabel(this.getJsonValue("label", contentObject));
        inputItem.setLableLayout(this.getJsonValue("lableLayout", contentObject));
        inputItem.setRule(this.getJsonValue("rule", contentObject));
        inputItem.setDefaultValue(this.getJsonValue("default", contentObject));
        String refreshId = this.getJsonValue("refreshItems", contentObject);
        if (!refreshId.equals("")) {
            String[] refreshIds = refreshId.split(",");
            List<String> refreshList = Arrays.asList(refreshIds);
            inputItem.setRefreshItems(refreshList);
        }
        inputItem.setInitParam(this.getJsonValue("param", contentObject));
        inputItem.setInitSript(this.getJsonValue("script", contentObject));
        String lenStr = this.getJsonValue("length", contentObject);
        if (!StringUtils.isNULLStr(lenStr)) {
            inputItem.setCompSpectLen(Integer.valueOf(lenStr));
        }
        return inputItem;
    }

    private String getJsonValue(String key, JSONObject jsonObject) {
        if (!jsonObject.has(key)) {
            return "";
        }
        String data = (String)jsonObject.get(key);
        if (StringUtils.isNULLStr(data)) {
            return "";
        }
        return data;
    }

    public String getScript() {
        return this.script;
    }

    public void setScript(String script) {
        this.script = script;
    }

    public String getParam() {
        return this.param;
    }

    public void setParam(String param) {
        this.param = param;
    }

    public String getRowKey() {
        return this.rowKey;
    }

    public void setRowKey(String rowKey) {
        this.rowKey = rowKey;
    }

    public List<InputItem> getInputItems() {
        return this.inputItems;
    }

    public void setInputItems(List<InputItem> inputItems) {
        this.inputItems = inputItems;
    }

    public void setCompsMap(Map<String, IInputComponent> compsMap) {
        this.compsMap = compsMap;
    }

    public Map<String, IInputComponent> getCompsMap() {
        return this.compsMap;
    }

    public String toString() {
        return "ItemRow [compsMap=" + this.compsMap + ", inputItems=" + this.inputItems + ", rowKey=" + this.rowKey + "]";
    }
}

