/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.bizpack.wizardparse.ui.step.multiexec;

import com.huawei.ism.tool.base.ui.UiMethod;
import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.bizpack.wizardparse.context.BizPackageContext;
import com.huawei.ism.tool.bizpack.wizardparse.ui.component.ItemsListCellRenderer;
import com.huawei.ism.tool.bizpack.wizardparse.ui.component.table.TableColumn;
import com.huawei.ism.tool.bizpack.wizardparse.ui.component.table.TableItem;
import com.huawei.ism.tool.bizpack.wizardparse.ui.step.AbstractBizStepLayout;
import com.huawei.ism.tool.bizpack.wizardparse.ui.step.multiexec.MultiDevExecStepCfg;
import com.huawei.ism.tool.bizpack.wizardparse.util.AutomateUtils;
import com.huawei.ism.tool.bizpack.wizardparse.util.PackagesResource;
import com.huawei.ism.ui.swing.table.IsmTable;
import com.huawei.ism.ui.swing.table.TableScrollPane;
import com.huawei.ism.util.UCD;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.List;
import javax.swing.Box;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.table.TableColumnModel;

public class MultiDevExecStepLayout
extends AbstractBizStepLayout {
    private static final long serialVersionUID = 3126080527328391554L;
    private static final int MUL_WIZARD_BLANK_SIZE = 45;
    private JSplitPane mulInputPanel = new JSplitPane(0, true);
    private JPanel mulDevDocLinkPanel = new JPanel();
    private JLabel mulDevPromptLabel = new JLabel();
    private JButton mulDevCheckButton;
    private JList detailList;
    private JScrollPane detailListScrollPane;
    private DefaultListModel detailListModel = new DefaultListModel();

    public MultiDevExecStepLayout(MultiDevExecStepCfg cfg) {
        BizPackageContext.getInstance().getId2LayoutMap().put(cfg.getId(), this);
        this.initUI(cfg);
        this.setCompName();
    }

    private void setCompName() {
        AutomateUtils.setNameAttribute(this.mulInputPanel, "mulInputPanel_devExecStep");
        AutomateUtils.setNameAttribute(this.mulDevDocLinkPanel, "mulDevDocLinkPanel");
        AutomateUtils.setNameAttribute(this.mulDevPromptLabel, "mulDevPromptLabel");
        AutomateUtils.setNameAttribute(this.mulDevCheckButton, "mulDevCheckButton");
        AutomateUtils.setNameAttribute(this.detailList, "detailList");
        AutomateUtils.setNameAttribute(this.detailListScrollPane, "detailListScrollPane");
    }

    private void initUI(MultiDevExecStepCfg multiCfg) {
        this.setBizCfg(multiCfg);
        String btnName = ResourceUtil.getString("bizpack.wizard.multiexec.btn." + multiCfg.getMode().getKey());
        this.mulDevCheckButton = UiMethod.createButton((String)btnName, (char)'O');
        JComponent view = null;
        if (multiCfg.getGuideLinkGroup().getLinks().size() > 0) {
            multiCfg.getGuideLinkGroup().init();
            this.mulDevDocLinkPanel = multiCfg.getGuideLinkGroup().getLinkPanel();
            view = UCD.buildVerticalBox(null, (Component[])new Component[]{this.mulDevDocLinkPanel, UiMethod.buildCompsLeft((int)0, (Component[])new Component[]{this.mulDevPromptLabel}), UiMethod.buildCompsLeft((int)0, (Component[])new Component[]{this.mulDevCheckButton}), UiMethod.buildCompsLeft((int)0, (Component[])new Component[]{this.mulInputPanel}), Box.createVerticalGlue()});
        } else {
            view = UCD.buildVerticalBox(null, (Component[])new Component[]{UiMethod.buildCompsLeft((int)0, (Component[])new Component[]{this.mulDevPromptLabel}), UiMethod.buildCompsLeft((int)0, (Component[])new Component[]{this.mulDevCheckButton}), UiMethod.buildCompsLeft((int)0, (Component[])new Component[]{this.mulInputPanel}), Box.createVerticalGlue()});
        }
        this.setViewInLayout(multiCfg, view, true);
    }

    public void init(MultiDevExecStepCfg cfg) {
        TableItem table = cfg.getIoTable();
        JPanel tableArea = this.createOneTable(table);
        JPanel detailArea = this.createOneList();
        this.mulInputPanel.setTopComponent(tableArea);
        this.mulInputPanel.setBottomComponent(detailArea);
        this.mulInputPanel.setDividerLocation(200);
        this.mulInputPanel.setBorder(null);
        PackagesResource util = BizPackageContext.getInstance().getCurBizPackage().getResUtil();
        this.setJLabelText(this.mulDevPromptLabel, util.getString(cfg.getPrompt()), 45);
    }

    private JPanel createOneTable(TableItem tableItem) {
        IsmTable table = tableItem.getComponent();
        TableScrollPane tableScrollPane = new TableScrollPane(table, true, true);
        JPanel myPanel = new JPanel();
        myPanel.setLayout(new BorderLayout());
        myPanel.add((Component)tableScrollPane);
        List<TableColumn> columnList = tableItem.getColumnIdList();
        TableColumnModel colModule = table.getColumnModel();
        for (int index = 0; index < columnList.size(); ++index) {
            TableColumn col = columnList.get(index);
            int len = col.getLength();
            if (len <= 0) continue;
            colModule.getColumn(index).setPreferredWidth(len);
        }
        return myPanel;
    }

    private JPanel createOneList() {
        this.detailList = new JList(this.detailListModel);
        this.detailList.setCellRenderer(new ItemsListCellRenderer());
        this.detailList.setSelectionMode(0);
        this.detailListScrollPane = new JScrollPane(this.detailList);
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.add(this.detailListScrollPane);
        return panel;
    }

    public JLabel getPromptLabel() {
        return this.mulDevPromptLabel;
    }

    public void setCheckButton(JButton checkButton) {
        this.mulDevCheckButton = checkButton;
    }

    public JButton getCheckButton() {
        return this.mulDevCheckButton;
    }

    public DefaultListModel getDetailListModel() {
        return this.detailListModel;
    }

    public void setDetailListModel(DefaultListModel detailListModel) {
        this.detailListModel = detailListModel;
    }

    public JList getDetailList() {
        return this.detailList;
    }

    public void setDetailList(JList detailList) {
        this.detailList = detailList;
    }
}

