/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.inspect.bmcconn.ssh;

import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.obase.connection.support.ConnUtils;
import com.huawei.ism.tool.obase.entity.ClusterNode;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.uMate.HWDiscover.model.HWDiscoverModel;
import com.huawei.uMate.common.UMateException;
import com.huawei.uMate.common.enums.CommonEnums;
import com.huawei.uMate.common.rest.BmcRedfishConnManagement;
import com.huawei.uMate.common.ssh.Shell;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BmcShellConnectionManagement {
    private static final Logger log = LoggerFactory.getLogger(BmcShellConnectionManagement.class);
    public static final int RETRY_TIMES = 3;
    private static ConcurrentHashMap<String, Shell> connectionPool = new ConcurrentHashMap();

    public static Shell getSSHAndSFTPConnectionForComputeStorage(String ip, String port, String name, String passWord) throws ToolException {
        ClusterNode clusterNode = BmcRedfishConnManagement.createClusterNode(ip, port, name, passWord);
        StringUtils.cleanPwd((String)passWord);
        return BmcShellConnectionManagement.getSSHAndSFTPConnection(clusterNode);
    }

    public static Shell getSSHAndSFTPConnection(ClusterNode clusterNode) throws ToolException {
        if (clusterNode == null || clusterNode.getBmcNode() == null) {
            log.error("release connection error.clusterNode is null");
            return Shell.EMPTY;
        }
        String poolKey = BmcShellConnectionManagement.getPoolKey(clusterNode);
        if (connectionPool.containsKey(poolKey) && connectionPool.get(poolKey) != null) {
            return connectionPool.get(poolKey);
        }
        return BmcShellConnectionManagement.createSshAndSFTPConnector(clusterNode);
    }

    private static Shell createSshAndSFTPConnector(ClusterNode clusterNode) throws ToolException {
        for (int tryTime = 1; tryTime <= 3; ++tryTime) {
            try {
                String poolKey = BmcShellConnectionManagement.getPoolKey(clusterNode);
                Shell connector = BmcShellConnectionManagement.creatBmcShall(clusterNode);
                connectionPool.put(poolKey, connector);
                return connector;
            }
            catch (UMateException umExc) {
                log.error("exception occurred on creation of ssh and sftp instance: {}.", (Object)umExc.getMessage());
                ConnUtils.sleep((int)(10000 * tryTime));
                continue;
            }
        }
        throw new ToolException(ResourceUtil.getString((String)"ssh.connection.failed"));
    }

    public static void releaseConnection(DevNode devNode) {
        if (devNode == null) {
            log.error("release connection error.devNode is null");
            return;
        }
        List clusterNodes = devNode.getClusterNodes();
        if (clusterNodes == null) {
            log.error("release connection error.clusterNode is null");
            return;
        }
        clusterNodes.stream().forEach(node -> BmcShellConnectionManagement.releaseConnection(node));
    }

    public static void releaseConnection(ClusterNode clusterNode) {
        if (clusterNode == null || clusterNode.getBmcNode() == null) {
            log.error("release connection error.clusterNode is null");
            return;
        }
        String poolKey = BmcShellConnectionManagement.getPoolKey(clusterNode);
        if (connectionPool.containsKey(poolKey) && connectionPool.get(poolKey) != null) {
            connectionPool.get(poolKey).disconnect();
            connectionPool.remove(poolKey);
        }
    }

    private static Shell creatBmcShall(ClusterNode clusterNode) throws UMateException {
        return new Shell(BmcShellConnectionManagement.convertDeviceEntity2HWDiscoverModel(clusterNode), CommonEnums.ShellType.ALL);
    }

    private static String getPoolKey(ClusterNode clusterNode) {
        return clusterNode.getManagementIp() + "_" + clusterNode.getBmcNode().getIp();
    }

    private static HWDiscoverModel convertDeviceEntity2HWDiscoverModel(ClusterNode clusterNode) throws UMateException {
        DevNode bmcDevNode = clusterNode.getBmcNode();
        HWDiscoverModel deviceModel = new HWDiscoverModel();
        deviceModel.setIPAddress(bmcDevNode.getIp());
        deviceModel.setUserName(bmcDevNode.getLoginUser().getUserName());
        deviceModel.setUserPwd(bmcDevNode.getLoginUser().getPassword());
        deviceModel.setSSHPort(bmcDevNode.getPort() + "");
        return deviceModel;
    }

    private BmcShellConnectionManagement() {
    }
}

