/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.uMate.common.utils;

import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.framework.platform.util.ApplicationContext;
import com.huawei.uMate.common.SystemConfig;
import java.util.Date;
import javax.swing.JFrame;

public class AppContext {
    public static final Date START_TOOL_DATE = new Date();
    private JFrame mainJFrame;
    private static final String TLS_PROTOCOLS = "umate_base_tls_protocols";
    private static final String PROTOCOL_PROPERTIES = "protocol.properties";
    private static final String[] DEFAULT_PROTOCOLS = new String[]{"TLSv1.2", "TLSv1.3"};
    private String[] protocol = this.getProtocolFromConfig();

    public static AppContext getInstance() {
        return Holder.INSTANCE;
    }

    private AppContext() {
    }

    public JFrame getMainJFrame() {
        return this.mainJFrame;
    }

    public void setMainJFrame(JFrame mainJFrame) {
        this.mainJFrame = mainJFrame;
    }

    public boolean isVerifyCert() {
        return SystemConfig.createSystemConfig().getIntConfigValue("isVerifyCert", 0) == 1;
    }

    public String[] getProtocolFromConfig() {
        if (this.protocol != null) {
            return this.protocol;
        }
        String toolBoxCfgPath = ApplicationContext.getToolBoxCfgPath();
        if (StringUtils.isNULLStr((String)toolBoxCfgPath)) {
            return DEFAULT_PROTOCOLS;
        }
        SystemConfig systemConfig = new SystemConfig(toolBoxCfgPath + PROTOCOL_PROPERTIES);
        String tlsProtocol = systemConfig.getConfigVlaue(TLS_PROTOCOLS);
        return StringUtils.isNULLStr((String)tlsProtocol) ? DEFAULT_PROTOCOLS : tlsProtocol.split(",");
    }

    private static final class Holder {
        private static final AppContext INSTANCE = new AppContext();

        private Holder() {
        }
    }
}

