/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.baize.base.collection;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.apache.commons.collections4.CollectionUtils;

public final class CollectionArithmeticUtils {
    private CollectionArithmeticUtils() {
    }

    @SafeVarargs
    public static <T> Collection<T> union(Collection<T> coll, Collection<T> ... otherColls) {
        Collection union = coll;
        for (Collection<T> collection : otherColls) {
            union = CollectionUtils.union(union, collection);
        }
        return union;
    }

    public static <T> Collection<T> union(Collection<Collection<T>> colls) {
        Collection union = new ArrayList();
        for (Collection<T> collection : colls) {
            union = CollectionUtils.union(union, collection);
        }
        return union;
    }

    @SafeVarargs
    public static <T> Collection<T> intersection(Collection<T> coll, Collection<T> ... otherColls) {
        Collection intersection = coll;
        if (CollectionUtils.isEmpty(intersection)) {
            return intersection;
        }
        for (Collection<T> collection : otherColls) {
            if (!CollectionUtils.isEmpty((Collection)(intersection = CollectionUtils.intersection(intersection, collection)))) continue;
            return intersection;
        }
        return intersection;
    }

    public static <T> Collection<T> intersection(Collection<Collection<T>> colls) {
        return colls.stream().reduce(CollectionUtils::intersection).orElse(Collections.emptyList());
    }

    @SafeVarargs
    public static <T> Collection<T> disjunction(Collection<T> coll, Collection<T> ... otherColls) {
        Collection disjunction = coll;
        for (Collection<T> collection : otherColls) {
            disjunction = CollectionUtils.disjunction(disjunction, collection);
        }
        return disjunction;
    }

    public static <T> Collection<T> disjunction(Collection<Collection<T>> colls) {
        return colls.stream().reduce(CollectionUtils::disjunction).orElse(Collections.emptyList());
    }

    @SafeVarargs
    public static <T> Collection<T> subtract(Collection<T> coll, Collection<T> ... otherColls) {
        Collection subtract = coll;
        for (Collection<T> collection : otherColls) {
            subtract = CollectionUtils.subtract(subtract, collection);
        }
        return subtract;
    }

    public static <T> Collection<T> subtract(Collection<Collection<T>> colls) {
        return colls.stream().reduce((acc, item) -> CollectionUtils.subtract((Iterable)acc, (Iterable)item)).orElse(Collections.emptyList());
    }
}

