/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.baize.base.commands.process;

import com.huawei.baize.base.commands.process.StreamGobbler;
import com.huawei.baize.base.common.Conditions;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ProcessInfo<O extends Consumer<String>, E extends Consumer<String>> {
    private static final Logger log = LoggerFactory.getLogger(ProcessInfo.class);
    private static final AtomicLong ID = new AtomicLong();
    private final String commandLine;
    private final Process process;
    private final O stdout;
    private final E stderr;
    private Thread outThread;
    private Thread errThread;

    public ProcessInfo(ProcessBuilder pb, O stdout, E stderr) throws IOException {
        List<String> commands = pb.command();
        Conditions.requireArgument(CollectionUtils.isNotEmpty(commands), "commands must be non-empty");
        this.stdout = stdout;
        this.stderr = stderr;
        this.commandLine = String.join((CharSequence)" ", commands);
        try {
            log.info("Starting {}", (Object)this.commandLine);
            this.process = pb.start();
        }
        catch (IOException e) {
            throw new IOException("Failed to start process: " + this.commandLine, e);
        }
        if (stdout != null) {
            this.outThread = new Thread((Runnable)new StreamGobbler(this.process.getInputStream(), (Consumer<String>)this.stdout), "process-stdout-" + ID.incrementAndGet());
            this.outThread.start();
        }
        if (stderr != null) {
            this.errThread = new Thread((Runnable)new StreamGobbler(this.process.getErrorStream(), (Consumer<String>)this.stderr), "process-stderr-" + ID.incrementAndGet());
            this.errThread.start();
        }
    }

    public void ensureDestroyed() {
        this.ensureDestroyed(1L, TimeUnit.SECONDS);
    }

    public void ensureDestroyed(long timeout, TimeUnit unit) {
        this.process.destroy();
        try {
            boolean dead = this.waitFor(timeout, unit);
            if (!dead) {
                this.process.destroyForcibly();
                log.info("Terminated forcibly {}", (Object)this);
            } else {
                log.info("Terminated {}", (Object)this);
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    public String getCommandLine() {
        return this.commandLine;
    }

    public int exitValue() throws IllegalThreadStateException {
        return this.process.exitValue();
    }

    public int exitValue(int defaultExitValue) {
        try {
            return this.process.exitValue();
        }
        catch (IllegalThreadStateException e) {
            return defaultExitValue;
        }
    }

    public E getStdErr() {
        return this.stderr;
    }

    public O getStdOut() {
        return this.stdout;
    }

    public boolean isAlive() {
        return this.process.isAlive();
    }

    public String toString() {
        int exitCode;
        StringBuilder builder = new StringBuilder();
        builder.append("ProcessInfo [");
        String separator = "";
        if (this.commandLine != null) {
            builder.append("commandLine=");
            builder.append(this.commandLine);
            separator = ", ";
        }
        if ((exitCode = this.exitValue(Integer.MAX_VALUE)) != Integer.MAX_VALUE) {
            builder.append(separator);
            builder.append("exitCode=");
            builder.append(exitCode);
        }
        builder.append(']');
        return builder.toString();
    }

    public ProcessInfo<O, E> waitFor() throws InterruptedException {
        this.process.waitFor();
        this.waitForThreads();
        return this;
    }

    public boolean waitFor(long timeout, TimeUnit unit) throws InterruptedException {
        boolean exit = this.process.waitFor(timeout, unit);
        if (exit) {
            this.waitForThreads();
        }
        return exit;
    }

    private void waitForThreads() throws InterruptedException {
        if (this.outThread != null) {
            this.outThread.join();
            this.outThread = null;
        }
        if (this.errThread != null) {
            this.errThread.join();
            this.errThread = null;
        }
    }
}

