/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.baize.base.commands.process;

import com.huawei.baize.base.annotations.NotNull;
import com.huawei.baize.base.commands.process.ProcessInfo;
import com.huawei.baize.base.commands.process.ProcessResult;
import com.huawei.baize.base.common.Conditions;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ProcessUtils {
    private static final Logger log = LoggerFactory.getLogger(ProcessUtils.class);
    private static final String COMMANDS_MUST_BE_NON_EMPTY = "Commands must be non-empty";

    private ProcessUtils() {
    }

    public static ProcessBuilder build(String ... commands) {
        Conditions.requireArgument(commands.length != 0, COMMANDS_MUST_BE_NON_EMPTY);
        return new ProcessBuilder(commands);
    }

    public static ProcessBuilder build(List<String> commands) {
        Conditions.requireArgument(CollectionUtils.isNotEmpty(commands), COMMANDS_MUST_BE_NON_EMPTY);
        return new ProcessBuilder(commands);
    }

    public static ProcessBuilder build(@NotNull Map<String, String> env, String ... commands) {
        Conditions.requireArgument(commands.length != 0, COMMANDS_MUST_BE_NON_EMPTY);
        ProcessBuilder pb = new ProcessBuilder(commands);
        pb.environment().putAll(env);
        return pb;
    }

    public static ProcessBuilder build(@NotNull Map<String, String> env, List<String> commands) {
        Conditions.requireArgument(CollectionUtils.isNotEmpty(commands), COMMANDS_MUST_BE_NON_EMPTY);
        ProcessBuilder pb = new ProcessBuilder(commands);
        pb.environment().putAll(env);
        return pb;
    }

    public static ProcessBuilder build(File directory, Map<String, String> env, String ... commands) {
        Conditions.requireArgument(commands.length != 0, COMMANDS_MUST_BE_NON_EMPTY);
        ProcessBuilder pb = new ProcessBuilder(commands);
        if (directory != null) {
            pb.directory(directory);
        }
        if (MapUtils.isNotEmpty(env)) {
            pb.environment().putAll(env);
        }
        return pb;
    }

    public static ProcessBuilder build(File directory, Map<String, String> env, List<String> commands) {
        Conditions.requireArgument(CollectionUtils.isNotEmpty(commands), COMMANDS_MUST_BE_NON_EMPTY);
        ProcessBuilder pb = new ProcessBuilder(commands);
        if (directory != null) {
            pb.directory(directory);
        }
        if (MapUtils.isNotEmpty(env)) {
            pb.environment().putAll(env);
        }
        return pb;
    }

    public static ProcessInfo<ProcessResult, ProcessResult> run(String ... commands) throws IOException, InterruptedException {
        return ProcessUtils.run(Arrays.asList(commands));
    }

    public static ProcessInfo<ProcessResult, ProcessResult> run(List<String> commands) throws IOException, InterruptedException {
        return ProcessUtils.start(ProcessUtils.build(commands)).waitFor();
    }

    public static ProcessInfo<ProcessResult, ProcessResult> run(long timeout, TimeUnit timeUnit, String ... commands) throws IOException, InterruptedException, TimeoutException {
        return ProcessUtils.run(timeout, timeUnit, Arrays.asList(commands));
    }

    public static ProcessInfo<ProcessResult, ProcessResult> run(long timeout, TimeUnit timeUnit, List<String> commands) throws IOException, InterruptedException, TimeoutException {
        ProcessInfo<ProcessResult, ProcessResult> processInfo = ProcessUtils.start(ProcessUtils.build(commands));
        boolean exit = processInfo.waitFor(timeout, timeUnit);
        if (!exit) {
            throw new TimeoutException("Execute command timeout");
        }
        return processInfo;
    }

    public static ProcessInfo<ProcessResult, ProcessResult> run(ProcessBuilder builder, long timeout, TimeUnit timeUnit) throws IOException, InterruptedException, TimeoutException {
        ProcessInfo<ProcessResult, ProcessResult> processInfo = ProcessUtils.start(builder);
        boolean exit = processInfo.waitFor(timeout, timeUnit);
        if (!exit) {
            throw new TimeoutException("Execute command timeout");
        }
        return processInfo;
    }

    public static ProcessInfo<ProcessResult, ProcessResult> start(ProcessBuilder builder) throws IOException {
        return new ProcessInfo<ProcessResult, ProcessResult>(builder, new ProcessResult(), new ProcessResult());
    }

    public static <O extends Consumer<String>, E extends Consumer<String>> ProcessInfo<O, E> start(ProcessBuilder builder, O stdout, E stderr) throws IOException {
        return new ProcessInfo<O, E>(builder, stdout, stderr);
    }
}

