/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.baize.base.math;

import com.huawei.baize.base.annotations.NotNull;
import com.huawei.baize.base.common.Conditions;
import org.apache.commons.lang3.ArrayUtils;

public final class Binary {
    private static final char MASK = '1';
    private static final char INT_BITS = ' ';

    private Binary() {
    }

    @NotNull
    public static char[] binary(int number) {
        Conditions.requireArgument(number > 0, "number must be greater than zero.");
        char[] array = Integer.toBinaryString(number).toCharArray();
        ArrayUtils.reverse((char[])array);
        return array;
    }

    public static boolean bitCheck(@NotNull char[] binaryArrays, int i) {
        Conditions.requireArgument(i >= 0, "number must be greater than or equal to zero.");
        return binaryArrays[i] == '1';
    }

    public static boolean bitCheck(int number, int index) {
        Conditions.requireArgument(number > 0, "number must greater than zero.");
        Conditions.requireArgument(index >= 0 && index < 32, "number must in range of [0, 31].");
        int mask = 1 << index;
        return (number & mask) != 0;
    }
}

