/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.baize.base.math;

import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.util.Objects;

public final class DecimalUtils {
    private DecimalUtils() {
    }

    public static String formatDecimal(double number, int precision, RoundingMode roundingMode) {
        Objects.requireNonNull(roundingMode, "mode must not be null");
        DecimalFormat format = new DecimalFormat("0");
        format.setMaximumFractionDigits(precision);
        format.setMinimumFractionDigits(precision);
        format.setRoundingMode(roundingMode);
        return format.format(number);
    }

    public static String formatDecimal(double number, int precision) {
        return DecimalUtils.formatDecimal(number, precision, RoundingMode.HALF_UP);
    }
}

