/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.baize.base.math;

import com.huawei.baize.base.regex.RegexExpression;
import com.huawei.baize.base.regex.RegexMatchUtils;

public final class DigitFloatUtils {
    private DigitFloatUtils() {
    }

    public static boolean isReal(String digit) {
        return RegexMatchUtils.matches(RegexExpression.DIGIT_HAS_SYMBOL_PATTERN, digit);
    }

    public static boolean isReal(String digit, int start, int end) {
        String regex = "^(\\-)?\\d+(\\.\\d{" + start + "," + end + "})?$";
        return RegexMatchUtils.matches(regex, digit);
    }

    public static boolean isPositiveReal(String digit, int start, int end) {
        String endStr = end == Integer.MAX_VALUE ? "," : (end == Integer.MIN_VALUE ? "" : "," + end);
        String regex = "^[0-9]+(.[0-9]{" + start + endStr + "})?$";
        return RegexMatchUtils.matches(regex, digit);
    }

    public static boolean isPositiveReal(String digit, int length) {
        return DigitFloatUtils.isPositiveReal(digit, length, Integer.MIN_VALUE);
    }

    public static boolean isPositiveRealLeast(String digit, int length) {
        return DigitFloatUtils.isPositiveReal(digit, length, Integer.MAX_VALUE);
    }

    public static boolean isPositiveFloat(String digit) {
        return RegexMatchUtils.matches(RegexExpression.DIGIT_POSITIVE_FLOAT_PATTERN, digit);
    }

    public static boolean isNegativeFloat(String digit) {
        return RegexMatchUtils.matches(RegexExpression.DIGIT_NEGATIVE_FLOAT_PATTERN, digit);
    }

    public static boolean isNotPositiveFloat(String digit) {
        return RegexMatchUtils.matches(RegexExpression.DIGIT_NOT_POSITIVE_FLOAT_PATTERN, digit);
    }

    public static boolean isNotNegativeFloat(String digit) {
        return RegexMatchUtils.matches(RegexExpression.DIGIT_NOT_NEGATIVE_FLOAT_PATTERN, digit);
    }

    public static boolean isDigitFloat(String digit) {
        return RegexMatchUtils.matches(RegexExpression.DIGIT_FLOAT_PATTERN, digit);
    }
}

