/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.baize.base.math.calculator;

import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;

final class LogicNotOperation {
    static final LogicNotOperation[] NOT_OPS = new LogicNotOperation[]{new LogicNotOperation(String.valueOf('!'), val -> val == false)};
    static final List<String> NOT_OPERS = Arrays.stream(NOT_OPS).map(LogicNotOperation::getOper).collect(Collectors.toList());
    private String oper;
    private Function<Boolean, Boolean> calc;

    static void calculate(List<String> ops, List<Object> bools) {
        if (CollectionUtils.containsAny(ops, NOT_OPERS)) {
            for (LogicNotOperation oper : NOT_OPS) {
                int i = 0;
                while (i < ops.size()) {
                    String curOp = ops.get(i);
                    if (oper.getOper().equals(curOp)) {
                        LogicNotOperation.calcNotSet(ops, bools, i);
                        continue;
                    }
                    ++i;
                }
            }
        }
    }

    private static void calcNotSet(List<String> ops, List<Object> obs, int i) {
        String oper = ops.remove(i);
        Boolean rValue = (Boolean)obs.remove(i);
        Boolean result = LogicNotOperation.cale(rValue, oper);
        obs.add(i, result);
    }

    private static Boolean cale(Boolean value, String op) {
        return Arrays.stream(NOT_OPS).filter(ob -> ob.getOper().equals(op)).findAny().map(ob -> ob.getCalc().apply(value)).orElseThrow(() -> new IllegalArgumentException("not support: " + op));
    }

    public String getOper() {
        return this.oper;
    }

    public Function<Boolean, Boolean> getCalc() {
        return this.calc;
    }

    public LogicNotOperation(String oper, Function<Boolean, Boolean> calc) {
        this.oper = oper;
        this.calc = calc;
    }
}

