/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.baize.base.regex;

import com.huawei.baize.base.regex.RegexExpression;
import com.huawei.baize.base.regex.RegexMatchUtils;

public final class RegexValidUtils {
    private RegexValidUtils() {
    }

    public static boolean checkPostCode(String postCode) {
        return RegexMatchUtils.matches(RegexExpression.POST_CODE_PATTERN, postCode);
    }

    public static boolean checkEmail(String email) {
        return RegexMatchUtils.matches(RegexExpression.EMAIL_PATTERN, email);
    }

    public static boolean checkAccount(String account, int start, int end) {
        String accountReg = "^[a-zA-Z][a-zA-Z0-9_]{" + start + "," + end + "}$";
        return RegexMatchUtils.matches(accountReg, account);
    }

    public static boolean checkPhone(String phone) {
        return RegexMatchUtils.matches(RegexExpression.PHONE_PATTERN, phone);
    }

    public static boolean checkIdCard(String idCard) {
        return RegexMatchUtils.matches(RegexExpression.ID_CARD_PATTERN, idCard);
    }

    public static boolean checkPassword(String password, int start, int end) {
        String passwordReg = "^[a-zA-Z]\\w{" + (start - 1) + "," + (end - 1) + "}$";
        return RegexMatchUtils.matches(passwordReg, password);
    }

    public static boolean checkDigitLetter(String digitLetter) {
        return RegexMatchUtils.matches(RegexExpression.DIGIT_LETTER_PATTERN, digitLetter);
    }

    public static boolean checkDigitLetterLine(String digitLetter) {
        return RegexMatchUtils.matches(RegexExpression.DIGIT_LETTER_LINE_PATTERN, digitLetter);
    }
}

