/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.baize.base.string;

import org.apache.commons.lang3.StringUtils;

public final class AnonymizeUtils {
    private static final int HALF_STRING = 2;
    private static final char ANONYMIZE_CHARACTER = '*';

    private AnonymizeUtils() {
    }

    public static String anonymize(String str, int anonymizeNum) {
        if (StringUtils.isEmpty((CharSequence)str) || anonymizeNum <= 0) {
            return str;
        }
        if (str.length() > anonymizeNum) {
            int midSize = str.length() / 2;
            int midNum = anonymizeNum / 2;
            return str.substring(0, midSize - midNum) + StringUtils.repeat((char)'*', (int)anonymizeNum) + str.substring(midSize + anonymizeNum - midNum);
        }
        return StringUtils.repeat((char)'*', (int)str.length());
    }

    public static String anonymizeEmail(String email, int anonymizeNum) {
        if (StringUtils.isEmpty((CharSequence)email) || anonymizeNum <= 0 || !StringUtils.contains((CharSequence)email, (int)64)) {
            return email;
        }
        String[] split = email.split("@");
        StringBuilder builder = new StringBuilder();
        if (split[0].length() <= anonymizeNum) {
            builder.append(StringUtils.repeat((char)'*', (int)split[0].length()));
        } else {
            builder.append(split[0], 0, split[0].length() - anonymizeNum).append(StringUtils.repeat((char)'*', (int)anonymizeNum));
        }
        if (split.length > 1) {
            builder.append('@').append(split[1]);
        }
        return builder.toString();
    }
}

