/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.baize.base.string;

import com.huawei.baize.base.character.CharacterUtils;
import com.huawei.baize.base.regex.RegexExpression;
import java.text.Normalizer;
import java.util.Arrays;
import java.util.Objects;
import java.util.regex.Pattern;
import org.apache.commons.lang3.CharUtils;
import org.apache.commons.lang3.StringUtils;

public final class StringCheckUtils {
    private StringCheckUtils() {
    }

    public static boolean containsChineseChar(String someStr) {
        Objects.requireNonNull(someStr);
        return Arrays.stream(someStr.chars().mapToObj(ch -> Character.valueOf((char)ch)).toArray(Character[]::new)).anyMatch(ch -> CharacterUtils.isChineseChar(ch.charValue()) || CharacterUtils.isChinesePunctuation(ch.charValue()));
    }

    public static boolean isPrintable(String str) {
        Objects.requireNonNull(str);
        return Arrays.stream(str.chars().mapToObj(ch -> Character.valueOf((char)ch)).toArray(Character[]::new)).allMatch(ch -> CharUtils.isAsciiPrintable((char)ch.charValue()) || CharacterUtils.isChineseChar(ch.charValue()) || CharacterUtils.isChinesePunctuation(ch.charValue()));
    }

    public static boolean isEmpty(CharSequence charSequence) {
        return charSequence == null || charSequence.length() == 0;
    }

    public static boolean isNotEmpty(CharSequence charSequence) {
        return !StringCheckUtils.isEmpty(charSequence);
    }

    public static boolean isBlank(CharSequence charSequence) {
        if (StringCheckUtils.isEmpty(charSequence)) {
            return true;
        }
        for (int j = 0; j < charSequence.length(); ++j) {
            if (Character.isWhitespace(charSequence.charAt(j))) continue;
            return false;
        }
        return true;
    }

    public static boolean isNotBlank(CharSequence charSequence) {
        return !StringCheckUtils.isBlank(charSequence);
    }

    public static boolean checkCharacterLength(String character, int start, int end) {
        String regex = "^.{" + start + "," + end + "}$";
        return Pattern.matches(regex, character);
    }

    public static boolean checkCharacterLength(String character, int length) {
        Objects.requireNonNull(character);
        int tempLen = Math.max(length, 0);
        String regex = "^.{0," + tempLen + "}$";
        return Pattern.matches(regex, character);
    }

    public static boolean checkLetter(String letter) {
        return RegexExpression.LETTER_PATTERN.matcher(letter).matches();
    }

    public static boolean checkUpperLetter(String letter) {
        return RegexExpression.UPPER_LETTER_PATTERN.matcher(letter).matches();
    }

    public static boolean checkLowerLetter(String letter) {
        return RegexExpression.LOWER_LETTER_PATTERN.matcher(letter).matches();
    }

    public static String normalize(String str) {
        if (null != str && StringCheckUtils.withAllHalfChar(str)) {
            return Normalizer.normalize(str, Normalizer.Form.NFC);
        }
        return str;
    }

    public static boolean withAllHalfChar(String str) {
        boolean result = true;
        if (null != str) {
            char[] cs;
            for (char value : cs = str.toCharArray()) {
                if ('\u3000' != value && (value <= '\uff00' || value >= '\uff5f')) continue;
                result = false;
                break;
            }
        }
        return result;
    }

    public static boolean checkEqualIgnoreEmpty(String s1, String s2) {
        if (StringUtils.isEmpty((CharSequence)s1) && StringUtils.isEmpty((CharSequence)s2)) {
            return true;
        }
        return null != s1 && s1.equals(s2);
    }
}

