/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.baize.base.string;

import java.io.StringWriter;
import java.util.Locale;

public final class StringEscapeUtils {
    private static final int VALUE_2 = 2;
    private static final int VALUE_4 = 4;
    private static final int VALUE_16 = 16;
    private static final int VALUE_32 = 32;
    private static final char VALUE_FFF = '\u0fff';
    private static final char VALUE_FF = '\u00ff';
    private static final char VALUE_7F = '\u007f';
    private static final char VALUE_F = '\u000f';

    private StringEscapeUtils() {
    }

    public static String escape(String str, boolean escapeSingleQuote) {
        if (str == null) {
            return null;
        }
        StringWriter writer = new StringWriter(str.length() * 2);
        for (char c : str.toCharArray()) {
            if (c > '\u0fff') {
                writer.write("\\u" + StringEscapeUtils.charToHexString(c));
                continue;
            }
            if (c > '\u00ff') {
                writer.write("\\u0" + StringEscapeUtils.charToHexString(c));
                continue;
            }
            if (c > '\u007f') {
                writer.write("\\u00" + StringEscapeUtils.charToHexString(c));
                continue;
            }
            if (c < ' ') {
                StringEscapeUtils.handleEscapeLessThan32(c, writer);
                continue;
            }
            StringEscapeUtils.handleEscapeLessThan32MoreThan0x7f(c, writer, escapeSingleQuote);
        }
        return writer.toString();
    }

    public static String unescape(String str) {
        if (str == null) {
            return null;
        }
        StringWriter writer = new StringWriter(str.length());
        StringBuilder unicodeBuilder = new StringBuilder(4);
        boolean withSlash = false;
        boolean inUnicode = false;
        for (char c : str.toCharArray()) {
            if (inUnicode) {
                unicodeBuilder.append(c);
                if (unicodeBuilder.length() != 4) continue;
                StringEscapeUtils.handleUnicodeToInt(writer, unicodeBuilder);
                unicodeBuilder.setLength(0);
                inUnicode = false;
                withSlash = false;
                continue;
            }
            if (withSlash) {
                withSlash = false;
                inUnicode = StringEscapeUtils.handleUnescapeHadSlash(c, writer);
                continue;
            }
            if (c == '\\') {
                withSlash = true;
                continue;
            }
            writer.write(c);
        }
        if (withSlash) {
            writer.write(92);
        }
        return writer.toString();
    }

    private static String charToHexString(char c) {
        return Integer.toHexString(c).toUpperCase(Locale.ENGLISH);
    }

    private static void handleEscapeLessThan32(char c, StringWriter sw) {
        switch (c) {
            case '\b': {
                sw.write(92);
                sw.write(98);
                break;
            }
            case '\n': {
                sw.write(92);
                sw.write(110);
                break;
            }
            case '\t': {
                sw.write(92);
                sw.write(116);
                break;
            }
            case '\f': {
                sw.write(92);
                sw.write(102);
                break;
            }
            case '\r': {
                sw.write(92);
                sw.write(114);
                break;
            }
            default: {
                if (c > '\u000f') {
                    sw.write("\\u00" + StringEscapeUtils.charToHexString(c));
                    break;
                }
                sw.write("\\u000" + StringEscapeUtils.charToHexString(c));
            }
        }
    }

    private static void handleEscapeLessThan32MoreThan0x7f(char c, StringWriter sw, boolean escapeSingleQuote) {
        switch (c) {
            case '\'': {
                if (escapeSingleQuote) {
                    sw.write(92);
                }
                sw.write(39);
                break;
            }
            case '\\': {
                sw.write(92);
                sw.write(92);
                break;
            }
            case '\"': {
                sw.write(92);
                sw.write(34);
                break;
            }
            case '/': {
                sw.write(92);
                sw.write(47);
                break;
            }
            default: {
                sw.write(c);
            }
        }
    }

    private static boolean handleUnescapeHadSlash(char c, StringWriter sw) {
        switch (c) {
            case '\\': {
                sw.write(92);
                break;
            }
            case '\'': {
                sw.write(39);
                break;
            }
            case '\"': {
                sw.write(34);
                break;
            }
            case 'r': {
                sw.write(13);
                break;
            }
            case 'f': {
                sw.write(12);
                break;
            }
            case 't': {
                sw.write(9);
                break;
            }
            case 'n': {
                sw.write(10);
                break;
            }
            case 'b': {
                sw.write(8);
                break;
            }
            case 'u': {
                return true;
            }
            default: {
                sw.write(92);
                sw.write(c);
            }
        }
        return false;
    }

    private static void handleUnicodeToInt(StringWriter writer, StringBuilder unicodeBuilder) {
        int value = Integer.parseInt(unicodeBuilder.toString(), 16);
        writer.write((char)value);
    }
}

