/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.baize.base.string;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public final class StringFormatUtils {
    private static final char LEFT_BRACE = '{';
    private static final String BRACE = "{}";
    private static final char SLASH = '\\';
    private static final int HOLDER_LEN = 2;

    private StringFormatUtils() {
    }

    public static String format(String format, Object ... params) {
        Objects.requireNonNull(format);
        if (params.length == 0) {
            return format;
        }
        StringBuilder sb = new StringBuilder();
        int start = 0;
        for (int index = 0; index < params.length; ++index) {
            int cursor = format.indexOf(BRACE, start);
            if (cursor == -1) {
                if (start == 0) {
                    return format;
                }
                sb.append(format, start, format.length());
                return sb.toString();
            }
            if (StringFormatUtils.isBeforeSlash(format, cursor)) {
                if (cursor > 1 && StringFormatUtils.isBeforeSlash(format, cursor - 1)) {
                    sb.append(format, start, cursor - 1);
                    StringFormatUtils.append(sb, params[index], new HashMap<Object[], Object>());
                    start = cursor + 2;
                    continue;
                }
                --index;
                sb.append(format, start, cursor - 1);
                sb.append('{');
                start = cursor + 1;
                continue;
            }
            sb.append(format, start, cursor);
            StringFormatUtils.append(sb, params[index], new HashMap<Object[], Object>());
            start = cursor + 2;
        }
        sb.append(format, start, format.length());
        return sb.toString();
    }

    private static boolean isBeforeSlash(String format, int index) {
        return index > 0 && format.charAt(index - 1) == '\\';
    }

    private static void append(StringBuilder sb, Object object, Map<Object[], Object> map) {
        if (object == null) {
            sb.append("null");
        } else if (!object.getClass().isArray()) {
            StringFormatUtils.objectAppend(sb, object);
        } else if (StringFormatUtils.isBaseArray(object)) {
            StringFormatUtils.arrayBaseAppends(sb, object);
        } else {
            StringFormatUtils.arrayObjectAppend(sb, (Object[])object, map);
        }
    }

    private static void objectAppend(StringBuilder sb, Object object) {
        sb.append(object);
    }

    private static boolean isBaseArray(Object object) {
        if (object instanceof boolean[]) {
            return true;
        }
        if (object instanceof byte[]) {
            return true;
        }
        if (object instanceof char[]) {
            return true;
        }
        if (object instanceof short[]) {
            return true;
        }
        if (object instanceof int[]) {
            return true;
        }
        if (object instanceof long[]) {
            return true;
        }
        if (object instanceof float[]) {
            return true;
        }
        return object instanceof double[];
    }

    private static void arrayObjectAppend(StringBuilder sb, Object[] objects, Map<Object[], Object> map) {
        sb.append('[');
        if (!map.containsKey(objects)) {
            map.put(objects, null);
            for (int i = 0; i < objects.length; ++i) {
                StringFormatUtils.append(sb, objects[i], map);
                if (i == objects.length - 1) continue;
                sb.append(", ");
            }
            map.remove(objects);
        } else {
            sb.append("...");
        }
        sb.append(']');
    }

    private static void arrayBaseAppend(StringBuilder sb, Object ... objects) {
        sb.append('[');
        for (int i = 0; i < objects.length; ++i) {
            sb.append(objects[i]);
            if (i == objects.length - 1) continue;
            sb.append(", ");
        }
        sb.append(']');
    }

    private static void arrayBaseAppends(StringBuilder sb, Object object) {
        if (object instanceof boolean[]) {
            StringFormatUtils.arrayBaseAppend(sb, new Object[]{(boolean[])object});
        } else if (object instanceof byte[]) {
            StringFormatUtils.arrayBaseAppend(sb, new Object[]{(byte[])object});
        } else if (object instanceof char[]) {
            StringFormatUtils.arrayBaseAppend(sb, new Object[]{(char[])object});
        } else if (object instanceof short[]) {
            StringFormatUtils.arrayBaseAppend(sb, new Object[]{(short[])object});
        } else if (object instanceof int[]) {
            StringFormatUtils.arrayBaseAppend(sb, new Object[]{(int[])object});
        } else if (object instanceof long[]) {
            StringFormatUtils.arrayBaseAppend(sb, new Object[]{(long[])object});
        } else if (object instanceof float[]) {
            StringFormatUtils.arrayBaseAppend(sb, new Object[]{(float[])object});
        } else if (object instanceof double[]) {
            StringFormatUtils.arrayBaseAppend(sb, new Object[]{(double[])object});
        }
    }
}

