/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.baize.base.time;

import com.huawei.baize.base.common.Conditions;
import com.huawei.baize.base.time.TimeConvertUtils;
import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.YearMonth;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoField;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalAdjusters;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public final class TimeOperateUtils {
    private static final int WEEKDAYS = 7;
    private static final int INVALID = -1;

    private TimeOperateUtils() {
    }

    public static long timePeriod(LocalDateTime startDateTime, LocalDateTime endDateTime, ChronoUnit chronoUnit) {
        Objects.requireNonNull(startDateTime);
        Objects.requireNonNull(endDateTime);
        Objects.requireNonNull(chronoUnit);
        return chronoUnit.between(startDateTime, endDateTime);
    }

    public static long timePeriod(String startDateTime, String endDateTime, String pattern, ChronoUnit chronoUnit) {
        LocalDateTime start = TimeConvertUtils.dateTimeStringToLocalDateTime(startDateTime, pattern);
        LocalDateTime end = TimeConvertUtils.dateTimeStringToLocalDateTime(endDateTime, pattern);
        return TimeOperateUtils.timePeriod(start, end, chronoUnit);
    }

    public static long timePeriod(long startTimeStamp, long endTimeStamp, ChronoUnit chronoUnit) {
        LocalDateTime start = TimeConvertUtils.longToLocalDateTime(startTimeStamp);
        LocalDateTime end = TimeConvertUtils.longToLocalDateTime(endTimeStamp);
        return TimeOperateUtils.timePeriod(start, end, chronoUnit);
    }

    public static LocalDateTime plusFromCurTime(long len, ChronoUnit chronoUnit) {
        LocalDateTime localDateTime = LocalDateTime.now();
        return TimeOperateUtils.plusFromLocalDateTime(localDateTime, len, chronoUnit);
    }

    public static LocalDateTime plusFromLocalDateTime(LocalDateTime localDateTime, long len, ChronoUnit chronoUnit) {
        Objects.requireNonNull(localDateTime);
        Objects.requireNonNull(chronoUnit);
        return localDateTime.plus(len, chronoUnit);
    }

    public static LocalDateTime minusFromCurTime(long len, ChronoUnit chronoUnit) {
        LocalDateTime localDateTime = LocalDateTime.now();
        return TimeOperateUtils.minusFromLocalDateTime(localDateTime, len, chronoUnit);
    }

    public static LocalDateTime minusFromLocalDateTime(LocalDateTime localDateTime, long len, ChronoUnit chronoUnit) {
        return localDateTime.minus(len, chronoUnit);
    }

    public static LocalDate nextDayOfWeekFromCurTime(DayOfWeek dayOfWeek) {
        Objects.requireNonNull(dayOfWeek);
        return LocalDate.now().with(TemporalAdjusters.next(dayOfWeek));
    }

    public static LocalDate previousDayOfWeekFromCurTime(DayOfWeek dayOfWeek) {
        Objects.requireNonNull(dayOfWeek);
        return LocalDate.now().with(temporal -> temporal.minus(7 - (dayOfWeek.getValue() - temporal.get(ChronoField.DAY_OF_WEEK)), ChronoUnit.DAYS));
    }

    public static LocalDate dayOfWeekFromCurTime(DayOfWeek dayOfWeek) {
        Objects.requireNonNull(dayOfWeek);
        return LocalDate.now().with(temporal -> temporal.minus(-(dayOfWeek.getValue() - temporal.get(ChronoField.DAY_OF_WEEK)), ChronoUnit.DAYS));
    }

    public static LocalDate nextDayOfMonthFromCurTime(int day) {
        return LocalDate.now().plusMonths(1L).withDayOfMonth(day);
    }

    public static LocalDate previousDayOfMonthFromCurTime(int day) {
        return LocalDate.now().minusMonths(1L).withDayOfMonth(day);
    }

    public static LocalDate dayOfMonthFromCurTime(int day) {
        return LocalDate.now().withDayOfMonth(day);
    }

    public static int getDaysByYearMonth(String yearMonth, String pattern) {
        Conditions.requireArgument(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{yearMonth}));
        Conditions.requireArgument(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{pattern}));
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern(pattern);
        YearMonth ym = YearMonth.parse(yearMonth, dateTimeFormatter);
        return ym == null ? -1 : ym.lengthOfMonth();
    }

    public static List<LocalDate> getMonthScope(YearMonth yearMonth) {
        Objects.requireNonNull(yearMonth);
        ArrayList<LocalDate> list = new ArrayList<LocalDate>();
        list.add(yearMonth.atDay(1));
        list.add(yearMonth.atEndOfMonth());
        return list;
    }

    public static List<LocalDate> getMonthScope() {
        return TimeOperateUtils.getMonthScope(YearMonth.now());
    }

    public static List<LocalDate> getMonthScope(String yearMonth, String pattern) {
        Conditions.requireArgument(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{yearMonth}));
        Conditions.requireArgument(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{pattern}));
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern(pattern);
        YearMonth ym = YearMonth.parse(yearMonth, dateTimeFormatter);
        return TimeOperateUtils.getMonthScope(ym);
    }

    public static List<LocalDate> getMonthScope(int year, int month) {
        YearMonth yearMonth = YearMonth.of(year, month);
        return TimeOperateUtils.getMonthScope(yearMonth);
    }

    public static long datePeriod(LocalDate startDate, LocalDate endDate, ChronoUnit chronoUnit) {
        Objects.requireNonNull(startDate);
        Objects.requireNonNull(endDate);
        Objects.requireNonNull(chronoUnit);
        return chronoUnit.between(startDate, endDate);
    }

    public static long datePeriod(String startDate, String endDate, String pattern, ChronoUnit chronoUnit) {
        LocalDate startLd = TimeConvertUtils.localDateStringToLocalDate(startDate, pattern);
        LocalDate endLd = TimeConvertUtils.localDateStringToLocalDate(endDate, pattern);
        return TimeOperateUtils.datePeriod(startLd, endLd, chronoUnit);
    }
}

