/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.channel.cert.service.impl;

import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.channel.cert.service.HttpsCertManager;
import com.huawei.ism.tool.channel.cert.service.HttpsCertPwdHelper;
import com.huawei.ism.tool.channel.cert.service.IHttpsCertService;
import com.huawei.ism.tool.channel.config.entity.InternetParams;
import com.huawei.ism.tool.channel.utils.HttpsPropUtils;
import com.huawei.ism.tool.channel.utils.InternetInfoKeeper;
import com.huawei.ism.tool.framework.platform.util.UserOpDataSaveUtil;
import com.huawei.ism.tool.https.conn.HttpsConnManager;
import com.huawei.ism.tool.https.entity.HttpProxy;
import com.huawei.ism.tool.https.entity.HttpsConnection;
import com.huawei.ism.tool.obase.utils.ApplicationContext;
import com.huawei.tool.framwork.util.func.LocalHostUtil;
import java.util.HashMap;
import java.util.Locale;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSocketFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpsCertService
implements IHttpsCertService {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpsCertService.class);

    @Override
    public int applyCert(InternetParams internetParams) {
        LOGGER.info("start to apply cert...");
        if (null == internetParams || null == internetParams.getSupportAccount() || StringUtils.isNULLStr((String)internetParams.getSupportAccount().getUserName()) || StringUtils.isNULLStr((String)internetParams.getSupportAccount().getPassword())) {
            LOGGER.error("parameters error.");
            return 1;
        }
        LOGGER.info("Try connect the green cloud");
        String url = HttpsPropUtils.getCertRequestUrl();
        int retCode = this.createCerConn(internetParams, HttpsCertManager.getInstance().getSslServerSocketFactory(), url);
        if (retCode != 0) {
            LOGGER.info("Try connect the yellow cloud");
            String spareUrl = HttpsPropUtils.getSpareCertRequestUrl();
            retCode = this.createCerConn(internetParams, HttpsCertManager.getInstance().getSslYellowServerSocketFactory(), spareUrl);
        }
        return retCode;
    }

    private int createCerConn(InternetParams internetParams, SSLSocketFactory sslServerSocketFactory, String url) {
        HttpsConnection httpsConnection;
        HttpProxy proxy;
        HttpProxy httpProxy = proxy = internetParams.isUseProxy() ? internetParams.getHttpProxy() : null;
        if (InternetInfoKeeper.getInstance().isNonProxy(url)) {
            proxy = null;
        }
        if (null == (httpsConnection = HttpsConnManager.getInstance().getHttpsConnByUrl(url, proxy, sslServerSocketFactory))) {
            LOGGER.info("https connection is null");
            return 3;
        }
        if (!httpsConnection.isSuccess()) {
            LOGGER.error("establish connection error:" + httpsConnection.getErrorCode());
            return 3;
        }
        HttpsURLConnection connection = httpsConnection.getConnection();
        String certPwd = new HttpsCertPwdHelper().generateCertPwd();
        this.setRequestParams(connection, internetParams, certPwd);
        int retCode = this.handleResponse(connection, certPwd, internetParams.getUserRole());
        StringUtils.cleanPwd((String)certPwd);
        return retCode;
    }

    private void setRequestParams(HttpsURLConnection connection, InternetParams internetParams, String certPwd) {
        LOGGER.info("set request params.");
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("supportUser", internetParams.getSupportAccount().getUserName());
        params.put("supportPwd", internetParams.getSupportAccount().getPassword());
        params.put("certPwd", certPwd);
        params.put("toolboxVersion", ApplicationContext.getInstance().getVersion());
        String applySupportType = internetParams.getUserRole();
        if ("".equals(applySupportType)) {
            applySupportType = com.huawei.ism.tool.framework.platform.util.ApplicationContext.getInstance().getUserRole();
        }
        params.put("supportType", applySupportType);
        params.put("cpuId", LocalHostUtil.getCPUSerial());
        params.put("publicKeyVersion", HttpsPropUtils.getPublicKeyVersioin());
        UserOpDataSaveUtil.updateUserInfo((String)"cpuId", (String)LocalHostUtil.getCPUSerial());
        HttpsConnManager.getInstance().setHttpsRequestParams(connection, params);
    }

    private int handleResponse(HttpsURLConnection connection, String certPwd, String role) {
        if (!HttpsConnManager.getInstance().isHttpsResponseSuccess(connection)) {
            LOGGER.error("handle response is failed , because of connect failed.");
            return 3;
        }
        int resultCode = 0;
        try {
            resultCode = Integer.parseInt(HttpsConnManager.getInstance().getHttpsResponseParams(connection, "resultCode"));
        }
        catch (NumberFormatException e) {
            LOGGER.error("response params format error.");
        }
        if (resultCode == 0) {
            String errrorMsgZh = HttpsConnManager.getInstance().getHttpsResponseParams(connection, "reasonZh");
            String errrorMsgEn = HttpsConnManager.getInstance().getHttpsResponseParams(connection, "reasonEn");
            HttpsCertManager.getInstance().getErrorMsgMap().put(Locale.CHINA, errrorMsgZh);
            HttpsCertManager.getInstance().getErrorMsgMap().put(Locale.ENGLISH, errrorMsgEn);
            LOGGER.error("handle response is failed , because of auth failed.");
            return 2;
        }
        new HttpsCertPwdHelper().saveCertPwd(certPwd, role);
        return this.getCertCode(connection, role);
    }

    private int getCertCode(HttpsURLConnection connection, String role) {
        String userDesc = connection.getHeaderField("userInfo");
        if (StringUtils.isNULLStr((String)userDesc)) {
            return 5;
        }
        boolean isSuccess = HttpsCertManager.getInstance().saveUserInfo(userDesc, role);
        return isSuccess ? 0 : 5;
    }

    @Override
    public boolean updateAndReplaceCert() {
        return HttpsCertManager.getInstance().replaceAndUpdateCert();
    }
}

