/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.channel.upload.task;

import com.huawei.ism.tool.channel.cert.service.HttpsCertManager;
import com.huawei.ism.tool.channel.upload.entity.UploadProcess;
import com.huawei.ism.tool.channel.upload.entity.UploadStatus;
import com.huawei.ism.tool.channel.upload.entity.UploadTask;
import com.huawei.ism.tool.channel.utils.HttpsPropUtils;
import java.io.File;

public class HttpsUploadChecker {
    public void checkUploadTask(UploadProcess uploadProcess, UploadTask task) {
        this.checkCert(uploadProcess);
        if (uploadProcess.isFailed()) {
            return;
        }
        this.checkFile(uploadProcess, task.getFileFullPath(), task.getFileName());
    }

    public void checkCert(UploadProcess uploadProcess) {
        boolean isValidCert = HttpsCertManager.getInstance().isValidCert();
        if (!isValidCert) {
            uploadProcess.setStatus(UploadStatus.FAILED);
            uploadProcess.setDescription("upload.cert.invalid");
        }
    }

    private void checkFile(UploadProcess uploadProcess, String filePath, String fileName) {
        File file = new File(filePath);
        if (!file.exists() || !file.isFile()) {
            uploadProcess.setStatus(UploadStatus.FAILED);
            uploadProcess.setDescription("upload.file.illegal");
            return;
        }
        String fileType = fileName.substring(fileName.lastIndexOf(".") + 1, fileName.length());
        if (!HttpsPropUtils.isAllowFileType(fileType)) {
            uploadProcess.setStatus(UploadStatus.FAILED);
            uploadProcess.setDescription("upload.file.unsupported.type");
        }
    }
}

