/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.base.utils;

import com.huawei.ism.tool.base.utils.FileUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ProperUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProperUtils.class);
    private static final ProperUtils INSTANCE = new ProperUtils();

    private ProperUtils() {
    }

    public static ProperUtils getInstance() {
        return INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putValue(File proFile, String key, String value) {
        FileOutputStream outputStream = null;
        try {
            boolean ret;
            if (!proFile.exists() && !(ret = FileUtils.createFile(proFile))) {
                LOGGER.error("delete file error.");
            }
            outputStream = new FileOutputStream(proFile);
            Properties properties = new Properties();
            properties.setProperty(key, value);
            properties.store(outputStream, proFile + " update.");
        }
        catch (RuntimeException e) {
            LOGGER.error("Save value error.", (Throwable)e);
        }
        catch (Exception e) {
            LOGGER.error("Save value error.", (Throwable)e);
        }
        finally {
            if (null != outputStream) {
                try {
                    outputStream.close();
                }
                catch (IOException e) {
                    LOGGER.error("Save value error.", (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getValue(File proFile, String key) {
        if (null == proFile || !proFile.exists()) {
            return "";
        }
        FileInputStream inputStream = null;
        try {
            inputStream = new FileInputStream(proFile);
            Properties properties = new Properties();
            properties.load(inputStream);
            String string = properties.getProperty(key);
            return string;
        }
        catch (Exception e) {
            LOGGER.error("Get value error.", (Throwable)e);
        }
        finally {
            if (null != inputStream) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    LOGGER.error("Get value error.", (Throwable)e);
                }
            }
        }
        return "";
    }
}

