/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.base.utils;

import com.huawei.ism.tool.base.utils.FilePathUtils;
import com.huawei.ism.tool.base.utils.StreamUtils;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.slf4j.LoggerFactory;

public final class SHA256Check {
    private static final char[] HEXCHAR = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private static final int MAGIC_NUMBER_2 = 2;
    private static final int MAGIC_NUMBER_3 = 3;
    private static final int MAGIC_NUMBER_255 = 255;
    private static final SHA256Check INSTANCE = new SHA256Check();

    private SHA256Check() {
    }

    public static SHA256Check getInstance() {
        return INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * WARNING - bad return control flow
     */
    public String getHash(String fileName) {
        String string;
        FileInputStream fis = null;
        MessageDigest md5 = null;
        try {
            fis = new FileInputStream(FilePathUtils.filterPath(fileName));
            byte[] buffer = new byte[1024];
            md5 = MessageDigest.getInstance("SHA-256");
            int numRead = 0;
            boolean isMD5Update = false;
            while ((numRead = ((InputStream)fis).read(buffer)) > 0) {
                isMD5Update = true;
                md5.update(buffer, 0, numRead);
            }
            string = isMD5Update ? this.toHexString(md5.digest()) : "";
        }
        catch (RuntimeException e) {
            LoggerFactory.getLogger(SHA256Check.class).error("SHA256 parse error. " + e);
            StreamUtils.closeStream(null, fis);
        }
        catch (Exception e2) {
            LoggerFactory.getLogger(SHA256Check.class).error("SHA256 parse error. " + e2);
            {
                catch (Throwable throwable) {
                    StreamUtils.closeStream(null, fis);
                    throw throwable;
                }
            }
            StreamUtils.closeStream(null, fis);
        }
        StreamUtils.closeStream(null, fis);
        return string;
        return "";
    }

    public String getShaCode(InputStream fis) {
        String code256 = this.getHash(fis);
        String code512 = SHA256Check.sha512CheckCode(code256);
        return SHA256Check.mixHash(code256, code512);
    }

    public String getShaCode(String fileName) {
        String code256 = this.getHash(fileName);
        String code512 = SHA256Check.sha512CheckCode(code256);
        return SHA256Check.mixHash(code256, code512);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getHash(InputStream fis) {
        MessageDigest md5 = null;
        try {
            byte[] buffer = new byte[1024];
            md5 = MessageDigest.getInstance("SHA-256");
            int numRead = 0;
            boolean isMD5Update = false;
            while ((numRead = fis.read(buffer)) > 0) {
                isMD5Update = true;
                md5.update(buffer, 0, numRead);
            }
            String string = isMD5Update ? this.toHexString(md5.digest()) : "";
            return string;
        }
        catch (RuntimeException e) {
            LoggerFactory.getLogger(SHA256Check.class).error("SHA256 parse error. " + e);
        }
        catch (Exception e) {
            LoggerFactory.getLogger(SHA256Check.class).error("SHA256 parse error. " + e);
        }
        finally {
            StreamUtils.closeStream(null, fis);
        }
        return "";
    }

    private String toHexString(byte[] b) {
        StringBuilder sb = new StringBuilder(b.length * 2);
        for (int i = 0; i < b.length; ++i) {
            sb.append(HEXCHAR[(b[i] & 0xF0) >>> 4]);
            sb.append(HEXCHAR[b[i] & 0xF]);
        }
        return sb.toString();
    }

    private static String sha512CheckCode(String message) {
        String result = "";
        try {
            MessageDigest sha512Digest = MessageDigest.getInstance("SHA-512");
            byte[] sha512Encode = sha512Digest.digest(message.getBytes("UTF-8"));
            StringBuilder sb = new StringBuilder(sha512Encode.length * 2);
            for (int i = 0; i < sha512Encode.length; ++i) {
                String hex = Integer.toHexString(0xFF & sha512Encode[i]);
                if (1 == hex.length()) {
                    sb.append('0');
                }
                sb.append(hex);
            }
            result = sb.toString();
        }
        catch (NoSuchAlgorithmException e) {
            LoggerFactory.getLogger(SHA256Check.class).error("No Such Hash Algorithm error");
        }
        catch (UnsupportedEncodingException e) {
            LoggerFactory.getLogger(SHA256Check.class).error("UnsupportedEncoding error");
        }
        return result;
    }

    private static String mixHash(String sha256, String sha512) {
        char[] char256 = sha256.toCharArray();
        char[] char512 = sha512.toCharArray();
        StringBuffer sb = new StringBuffer();
        int j = 0;
        int k = 0;
        for (int i = 0; i < char256.length + char512.length; ++i) {
            if (0 == i % 3) {
                sb.append(char256[j]);
                ++j;
                continue;
            }
            sb.append(char512[k]);
            ++k;
        }
        return sb.toString();
    }
}

