/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.framework.platform.exception;

import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.framework.platform.context.IPropertiesManager;
import java.util.Locale;

public class ToolException
extends Exception {
    private static final String DEFAULT_STRING = "--";
    private boolean msgIsId = true;
    private String errorId = "";
    private String errMsg = "";
    private Object[] args = new Object[0];
    private Object operationObject = null;
    private static final long serialVersionUID = -7146824917855557593L;

    public ToolException(String errorId) {
        this(errorId, true);
    }

    public ToolException(String errMsg, boolean msgIsId) {
        this.errorId = errMsg;
        this.msgIsId = msgIsId;
    }

    public ToolException(String errMsg, boolean msgIsId, Throwable throwAble) {
        super(throwAble);
        this.errorId = errMsg;
        this.msgIsId = msgIsId;
    }

    public ToolException(String errorId, Object[] args) {
        this.errorId = errorId;
        this.args = args == null ? null : (Object[])args.clone();
    }

    public ToolException(String errorId, Throwable throwAble) {
        super(throwAble);
        this.errorId = errorId;
    }

    public ToolException(String errorId, String message, Throwable throwAble) {
        super(message, throwAble);
        this.errorId = errorId;
        this.errMsg = message;
    }

    public ToolException(String errorId, Object[] args, String message, Throwable throwAble) {
        super(message, throwAble);
        this.errorId = errorId;
        this.args = args == null ? null : (Object[])args.clone();
    }

    public Object getOperationObject() {
        return this.operationObject;
    }

    public void setOperationObject(Object operationObject) {
        this.operationObject = operationObject;
    }

    public String getErrorId() {
        return this.errorId;
    }

    public String getErrorLocaleDescription(IPropertiesManager mgr, Locale loc) {
        if (!this.msgIsId) {
            return this.errorId;
        }
        String des = DEFAULT_STRING;
        if (this.msgIsId) {
            des = mgr.getStringWithParams(loc, this.errorId, this.args);
        }
        if (DEFAULT_STRING.equals(des)) {
            des = this.errorId;
        }
        return des;
    }

    public String getErrorLocaleDescription() {
        if (!this.msgIsId) {
            return this.errorId;
        }
        String des = DEFAULT_STRING;
        if (this.msgIsId) {
            des = ResourceUtil.getStringWithParams(this.errorId, this.args);
        }
        if (DEFAULT_STRING.equals(des)) {
            des = this.errorId;
        }
        return des;
    }

    @Override
    public String toString() {
        return super.toString() + ("\nOperation Object:" + this.getOperationObject()) + ("\nError Code:" + this.getErrorId());
    }

    public String getErrMsg() {
        return this.errMsg;
    }
}

