/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.framework.platform.util;

import com.huawei.ism.tool.base.utils.ContextUtil;
import com.huawei.ism.tool.base.utils.DateUtil;
import com.huawei.ism.tool.base.utils.FilePathUtils;
import com.huawei.ism.tool.base.utils.FileUtils;
import com.huawei.ism.tool.base.utils.IniReader;
import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.base.utils.SceneUtils;
import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.base.utils.VerifyUtil;
import com.huawei.ism.tool.base.utils.reflection.ReflectionUtils;
import com.huawei.ism.tool.certbase.integrity.CheckFileIntegrityUtils;
import com.huawei.ism.tool.framework.platform.PlatformAppContext;
import com.huawei.ism.tool.framework.platform.common.annotation.FieldInfo;
import com.huawei.ism.tool.framework.platform.common.data.UserOpToolBasicData;
import com.huawei.ism.tool.framework.platform.common.data.UserOpToolData;
import com.huawei.ism.tool.framework.platform.common.data.UserOpToolDataBase;
import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import com.huawei.ism.tool.framework.platform.util.ApplicationContext;
import com.huawei.ism.tool.framework.pubservice.common.devmanage.ISceneEnvironment;
import com.huawei.ism.tool.framework.pubservice.entity.SceneValue;
import com.huawei.ism.tool.framework.pubservice.entity.TaskResult;
import com.huawei.ism.tool.framework.pubservice.exception.EncapsulatedRuntimeException;
import com.huawei.ism.tool.framework.pubservice.impl.UserOpDataServForHostEvalImpl;
import com.huawei.ism.tool.framework.pubservice.impl.UserOpDataServImpl;
import com.huawei.ism.tool.framework.pubservice.sceneimpl.SceneEnvironmentImpl;
import com.huawei.ism.tool.framework.pubservice.service.IUserOpDataServ;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.lang.reflect.Field;
import java.nio.channels.FileLock;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import org.slf4j.Logger;

public class UserOpDataSaveUtil {
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(UserOpDataSaveUtil.class);
    private static final String CONFIGURATION = "configuration";
    private static final String CUR_USER_INFO = "curUser.info";
    private static final int SLEEP_TIME = 100;
    private static final String LOG_LOCK_SUFFIX = ".log.loc";
    private static final String GUEST = "GUEST";
    public static final String APP_VERSION = "app.version";
    private static final String TOOL_BOX_SYSTEM_CFG = UserOpDataSaveUtil.getToolSystemCfg();
    private static final String TOOL_INI = "tool.ini";
    public static final String TOOL_VERSION = "tool.version";
    public static final String TOOL_VERSION_VIEW = "version.for.view";
    public static final String TOOL_NAME = "tool.name";
    private static final int RE_CREATE_DIR_TIMES = 5;
    private static final String UPLOAD_TOOL = "/upload/tool/";
    public static final String OP_LOGFILE_SUFFIX = ".log";
    private static final String OP_LOGFILE_SPLIT = "_";
    private static final String OP_LOGFILE_PREFIX = "alltools_";
    private static final String TOOLS = "tools";
    private static final String TOOL_ID = "tool.name";
    private static final String IS_CHINA_TOOLBOX_KEY = "toolkit.app.zh.version";
    private static final String IS_CHINA_TOOLBOX_KEY_INBOX = "toolkit.app.zh_or_en.version";
    public static final String IS_ENGLISH = "isEnglish";
    public static final List<String> FRU_TOOL_NAMES = new ArrayList<String>(Arrays.asList("FRU", "CRU"));

    public static String getToolBoxPath() {
        String workPath = ApplicationContext.getInstance().getWorkPath();
        if (StringUtils.isNULLStr(workPath)) {
            throw new NullPointerException();
        }
        return SceneUtils.isToolBoxGetDir(workPath = Normalizer.normalize(workPath, Normalizer.Form.NFKC)) ? workPath : workPath.substring(0, workPath.lastIndexOf(TOOLS));
    }

    public static String getOpDataUploadPath() {
        String filePath = UserOpDataSaveUtil.getToolBoxPath() + UPLOAD_TOOL;
        UserOpDataSaveUtil.checkAndMakeFile(new File(filePath), true);
        return filePath;
    }

    public static boolean checkAndMakeFile(File file, boolean isFolder) {
        for (int tryTimes = 5; tryTimes > 0 && !file.exists(); --tryTimes) {
            try {
                if (isFolder && file.mkdirs()) {
                    return true;
                }
                if (!isFolder && !file.createNewFile()) {
                    LOGGER.error("make file error! times " + tryTimes);
                }
            }
            catch (RuntimeException e) {
                LOGGER.error("make file error! times " + tryTimes);
            }
            catch (Exception e) {
                LOGGER.error("make file error! times " + tryTimes);
            }
            UserOpDataSaveUtil.sleep(100L);
        }
        return file.exists();
    }

    public static Map<Integer, Field> getFieldIndexMap(Class<?> object) {
        Field[] commFields;
        HashMap<Integer, Field> indexFieldMap = new HashMap<Integer, Field>();
        for (Field field : commFields = object.getDeclaredFields()) {
            FieldInfo fieldInfo = field.getAnnotation(FieldInfo.class);
            if (fieldInfo == null) continue;
            indexFieldMap.put(fieldInfo.index(), field);
        }
        return indexFieldMap;
    }

    public static String getToolIniProp(String peop) {
        try {
            String cfgFile = ApplicationContext.getInstance().getWorkPath() + File.separator + TOOL_INI;
            File file = new File(cfgFile);
            if (file.exists()) {
                return new IniReader(file).getString(peop);
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String getToolIniProp(String toolName, String peop) {
        String cfgFile = UserOpDataSaveUtil.getToolBoxPath() + File.separator + TOOLS + File.separator + toolName + File.separator + TOOL_INI;
        IniReader reader = new IniReader(new File(cfgFile));
        return reader.getString(peop);
    }

    public static boolean getToolIniBoolProp(String peop) {
        String cfgFile = ApplicationContext.getInstance().getWorkPath() + File.separator + TOOL_INI;
        IniReader reader = new IniReader(new File(cfgFile));
        return "true".equals(reader.getString(peop));
    }

    public static String getToolIniPath() {
        String cfgFile = ApplicationContext.getInstance().getWorkPath() + File.separator + TOOL_INI;
        return cfgFile;
    }

    public static String getToolBoxIniProp(String peop) {
        String cfgFile = UserOpDataSaveUtil.getToolBoxPath() + TOOL_BOX_SYSTEM_CFG;
        return ResourceUtil.getPropOfFile(cfgFile, peop);
    }

    public static String getSubToolIniProp(String peop) {
        String cfgFile = ApplicationContext.getInstance().getWorkPath() + TOOL_BOX_SYSTEM_CFG;
        return ResourceUtil.getPropOfFile(cfgFile, peop);
    }

    public static List<String> getAllToolVersion() {
        String cfgFile = UserOpDataSaveUtil.getToolBoxPath() + File.separator + TOOLS;
        File dir = new File(cfgFile);
        File[] files = dir.listFiles(File::isDirectory);
        if (files == null) {
            return Collections.emptyList();
        }
        ArrayList<String> res = new ArrayList<String>();
        for (File file : files) {
            String fileName = file.getName();
            res.add(String.format("\"%s\":[\"%s\", \"%s\"]", fileName, UserOpDataSaveUtil.getToolIniProp(fileName, "date"), UserOpDataSaveUtil.getToolIniProp(fileName, TOOL_VERSION)));
        }
        return res;
    }

    public static void initOpData() {
        try {
            UserOpToolData userOpToolData = new UserOpToolData();
            userOpToolData.setOpenToolTime(DateUtil.toBeiJingTimeMillis(new Date()));
            userOpToolData.setToolVersion(UserOpDataSaveUtil.getToolIniProp(TOOL_VERSION));
            userOpToolData.setToolBoxVersion(UserOpDataSaveUtil.getToolBoxIniProp(APP_VERSION));
            String userAccount = ApplicationContext.getInstance().getToolLoginUser().getUserAccount();
            userOpToolData.setUserAccount(userAccount == null ? GUEST : userAccount);
            userOpToolData.setToolName(UserOpDataSaveUtil.getToolIniProp("tool.name"));
            userOpToolData.setSceneId(UserOpDataSaveUtil.getSceneID());
            ApplicationContext.getInstance().setUserOpData(userOpToolData);
        }
        catch (Exception e) {
            LOGGER.error("init Opdata error!", (Throwable)e);
        }
    }

    private static String getSceneID() {
        SceneValue sceneValue;
        try {
            ISceneEnvironment environment = SceneEnvironmentImpl.getInstance();
            sceneValue = (SceneValue)environment.getEnvirValueByKey("jsonScene");
        }
        catch (Exception e) {
            return "";
        }
        if (null == sceneValue) {
            return "";
        }
        return sceneValue.getMainScene() + " : " + sceneValue.getSubScene();
    }

    public static List<Field> getFieldsNeed2Save(Object object) {
        List<Field> fieldList = ReflectionUtils.getFieldOfClassAndParent(object);
        Iterator<Field> it = fieldList.iterator();
        while (it.hasNext()) {
            Field field = it.next();
            FieldInfo info = field.getAnnotation(FieldInfo.class);
            if (info != null && info.isSaveToFile()) continue;
            it.remove();
        }
        return fieldList;
    }

    public static <T extends UserOpToolBasicData> TaskResult saveUserOpdata(T userOpData) {
        IUserOpDataServ impl = UserOpDataServImpl.getInstance();
        return impl.saveUserOpData(userOpData);
    }

    public static <T extends UserOpToolBasicData> TaskResult saveUserOpdata(T userOpData, UserOpToolData opCommonData) {
        IUserOpDataServ impl = UserOpDataServImpl.getInstance();
        return impl.saveUserOpData(userOpData, opCommonData);
    }

    public static void createLockMarker(File file) {
        try {
            String lockFile = file.getCanonicalPath().replace(OP_LOGFILE_SUFFIX, LOG_LOCK_SUFFIX);
            File lFile = new File(lockFile);
            if (!file.exists() && !UserOpDataSaveUtil.checkAndMakeFile(file, false)) {
                throw new EncapsulatedRuntimeException("create Log file error!");
            }
            if (!lFile.exists() && !UserOpDataSaveUtil.checkAndMakeFile(lFile, false)) {
                throw new EncapsulatedRuntimeException("create Log lock file error!");
            }
        }
        catch (IOException e) {
            throw new EncapsulatedRuntimeException("get Log lock file error!");
        }
    }

    public static String getNewLogFile() {
        String fileName = UserOpDataSaveUtil.getLogFilePath();
        File file = new File(fileName);
        while (file.exists()) {
            fileName = UserOpDataSaveUtil.getLogFilePath();
            file = new File(fileName);
        }
        return fileName;
    }

    private static File[] findValidFiles(String savePath) {
        return new File(savePath).listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                if (file.isDirectory()) {
                    return false;
                }
                String fileName = file.getName();
                return fileName.startsWith(UserOpDataSaveUtil.OP_LOGFILE_PREFIX) && fileName.endsWith(UserOpDataSaveUtil.OP_LOGFILE_SUFFIX);
            }
        });
    }

    private static String findFileToSave() {
        try {
            String savePath = UserOpDataSaveUtil.getOpDataUploadPath();
            File[] logFiles = UserOpDataSaveUtil.findValidFiles(savePath);
            if (logFiles == null || logFiles.length == 0) {
                return UserOpDataSaveUtil.getNewLogFile();
            }
            Arrays.sort(logFiles, new FileUtils.FileComp());
            if (logFiles[0].length() >= 0x100000L) {
                return UserOpDataSaveUtil.getNewLogFile();
            }
            return logFiles[0].getCanonicalPath();
        }
        catch (Exception e) {
            LOGGER.error("Find file to save error!", (Throwable)e);
            return UserOpDataSaveUtil.getNewLogFile();
        }
    }

    public static String lockAndGetLogWriteFile() {
        String logFile = UserOpDataSaveUtil.findFileToSave();
        UserOpDataSaveUtil.createLockMarker(new File(logFile));
        return logFile;
    }

    public static String getLockFileName(String fileName) {
        return fileName.replace(OP_LOGFILE_SUFFIX, LOG_LOCK_SUFFIX);
    }

    private static String getLogFilePath() {
        Date curDate = new Date();
        StringBuilder fileName = new StringBuilder(UserOpDataSaveUtil.getOpDataUploadPath()).append(OP_LOGFILE_PREFIX).append(DateUtil.toBeiJingTimeDay(curDate)).append(OP_LOGFILE_SPLIT).append(DateUtil.toBeiJingTimeMillis(curDate)).append(OP_LOGFILE_SUFFIX);
        return fileName.toString();
    }

    public static boolean deleteFileLock(File file) {
        for (int times = 5; file.exists() && times > 0; --times) {
            if (file.delete()) {
                return true;
            }
            UserOpDataSaveUtil.sleep(100L);
        }
        LOGGER.error("delete file error:" + file.getName());
        return false;
    }

    public static void sleep(long time) {
        try {
            Thread.sleep(time);
        }
        catch (InterruptedException e) {
            LOGGER.error("delete file error", (Throwable)e);
        }
    }

    public static <T extends UserOpToolBasicData> TaskResult batchSaveUserOpdata(List<T> userOpDatas) {
        IUserOpDataServ impl = UserOpDataServImpl.getInstance();
        if (UserOpDataSaveUtil.isChinaToolBox()) {
            LOGGER.info("is ChinaZoneToolBox,begin save user data.");
            return impl.batchSaveUserOpdata(userOpDatas);
        }
        LOGGER.info("is not ChinaZoneToolBox,do not save user data.");
        return new TaskResult();
    }

    public static <T extends UserOpToolDataBase> TaskResult batchSaveUserOpdataForHostEval(List<T> userOpDatas) {
        if (UserOpDataSaveUtil.isChinaToolBox()) {
            LOGGER.info("is ChinaZoneToolBox,begin save user data.");
            IUserOpDataServ impl = UserOpDataServForHostEvalImpl.getInstance();
            return ((UserOpDataServForHostEvalImpl)impl).batchSaveUserOpdataForEval(userOpDatas);
        }
        LOGGER.info("is not ChinaZoneToolBox,do not save user data.");
        return new TaskResult();
    }

    public static <T extends UserOpToolBasicData> TaskResult batchSaveUserOpdata(List<T> userOpDatas, UserOpToolData opCommonData) {
        if (UserOpDataSaveUtil.isChinaToolBox()) {
            LOGGER.info("is ChinaZoneToolBox,begin save user data.");
            IUserOpDataServ impl = UserOpDataServImpl.getInstance();
            return impl.batchSaveUserOpdata(userOpDatas, opCommonData);
        }
        LOGGER.info("is not ChinaZoneToolBox,do not save user data.");
        return new TaskResult();
    }

    public static boolean isChinaToolBox() {
        return Boolean.valueOf(System.getenv(IS_CHINA_TOOLBOX_KEY)) != false || !PlatformAppContext.getInstance().getFunctionBooleanByKey(IS_CHINA_TOOLBOX_KEY_INBOX);
    }

    public static void setCloseToolTime(Date date) {
        UserOpToolData opCommonData = ApplicationContext.getInstance().getUserOpData();
        if (opCommonData != null) {
            opCommonData.setCloseToolTime(DateUtil.toBeiJingTimeMillis(date));
        }
    }

    public static void releaseLock(FileLock lock, String logFile) {
        if (logFile == null || lock == null) {
            return;
        }
        try {
            if (lock.isValid()) {
                lock.release();
            }
            File lFile = new File(logFile.replace(OP_LOGFILE_SUFFIX, LOG_LOCK_SUFFIX));
            UserOpDataSaveUtil.deleteFileLock(lFile);
        }
        catch (Exception e) {
            LOGGER.error("delete file lock marker error", (Throwable)e);
        }
    }

    public static String getFiledName(Field field) {
        FieldInfo fieldInfo = field.getAnnotation(FieldInfo.class);
        if (null != fieldInfo) {
            return StringUtils.isNULLStr(fieldInfo.name()) ? field.getName() : fieldInfo.name();
        }
        return field.getName();
    }

    public static void updateUserInfo(String key, String val) {
        try {
            if (!ContextUtil.isInToolBox()) {
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info("not the toolBox. update cancel:update userInfo:" + key + " val :" + val);
                }
                return;
            }
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("update userInfo:" + key + " val :" + val);
            }
            TreeMap<String, String> infoMap = new TreeMap<String, String>();
            infoMap.put(key, val);
            UserOpDataSaveUtil.updateUserInfo(infoMap);
        }
        catch (Exception e) {
            LOGGER.error("error updateUserInfo!", (Throwable)e);
        }
    }

    private static void updateUserInfo(Map<String, String> info) {
        Path path = UserOpDataSaveUtil.getUserInfoPath();
        StringBuilder infoStr = new StringBuilder();
        Map<String, String> oldMap = UserOpDataSaveUtil.resloveCurInfo();
        UserOpDataSaveUtil.refreshMemUserInfo(info, infoStr, oldMap);
        UserOpDataSaveUtil.refreshLocUserInfo(path, infoStr);
    }

    private static void refreshMemUserInfo(Map<String, String> info, StringBuilder infoStr, Map<String, String> oldMap) {
        for (Map.Entry<String, String> entry : info.entrySet()) {
            oldMap.put(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<String, String> entry : oldMap.entrySet()) {
            infoStr.append(entry.getKey()).append(':').append(entry.getValue()).append(';');
        }
    }

    private static void refreshLocUserInfo(Path path, StringBuilder infoStr) {
        try {
            if (Files.exists(path, new LinkOption[0])) {
                Files.delete(path);
            }
            Files.write(path, infoStr.toString().getBytes(Charset.defaultCharset()), new OpenOption[0]);
        }
        catch (Exception e) {
            LOGGER.error("write file error!", (Throwable)e);
        }
    }

    public static Map<String, String> resloveCurInfo() {
        TreeMap<String, String> oldMap = new TreeMap<String, String>();
        String oldInfo = UserOpDataSaveUtil.getSupportUserInfo();
        if (!StringUtils.isNULLStr(oldInfo)) {
            String[] oldStr = oldInfo.split(";");
            for (int i = 0; i < oldStr.length; ++i) {
                String[] singleInfo;
                if (StringUtils.isNULLStr(oldStr[i]) || (singleInfo = oldStr[i].split(":")).length <= 1) continue;
                oldMap.put(singleInfo[0], singleInfo[1]);
            }
        }
        return oldMap;
    }

    public static String getSupportUserInfo() {
        String userInfo = null;
        try {
            Path path = UserOpDataSaveUtil.getUserInfoPath();
            userInfo = new String(Files.readAllBytes(path), Charset.defaultCharset());
        }
        catch (Exception e) {
            LOGGER.error("error get cpuId!", (Throwable)e);
        }
        return userInfo;
    }

    public static String getViewVersion() {
        String viewVersion = UserOpDataSaveUtil.getToolIniProp(TOOL_VERSION_VIEW);
        return !VerifyUtil.isEmpty(viewVersion) ? viewVersion : UserOpDataSaveUtil.getToolIniProp(TOOL_VERSION);
    }

    private static Path getUserInfoPath() {
        return Paths.get(ContextUtil.getToolBoxPath(), CONFIGURATION, CUR_USER_INFO);
    }

    private static String getToolSystemCfg() {
        LOGGER.info("get tool system cfg");
        if (ApplicationContext.getInstance().isWindowsOS()) {
            return "\\configuration\\system.properties";
        }
        return "/configuration/system.properties";
    }

    public static boolean isInnerDevAndTestEnv() {
        return UserOpDataSaveUtil.validateTempCertFile("cmsImportPermit", "importPermit.xml", "importPermit.xml.crl", "importPermit.xml.cms");
    }

    public static boolean isAutoTestEnv() {
        return UserOpDataSaveUtil.validateTempCertFile("autoTest", "autoTest.xml", "autoTest.xml.crl", "autoTest.xml.cms");
    }

    private static boolean validateTempCertFile(String certDirName, String xmlName, String crlName, String cmsName) {
        String certDirPath = String.join((CharSequence)File.separator, UserOpDataSaveUtil.getToolBoxPath(), "temp", certDirName);
        File certDir = new File(certDirPath);
        if (!certDir.exists() || !certDir.isDirectory() || Objects.isNull(certDir.listFiles())) {
            return false;
        }
        File xmlFile = new File(certDir, xmlName);
        File crlFile = new File(certDir, crlName);
        File cmsFile = new File(certDir, cmsName);
        if (!(xmlFile.exists() && cmsFile.exists() && crlFile.exists())) {
            return false;
        }
        return CheckFileIntegrityUtils.checkFileByCms((String)SceneUtils.HUAWEI_ROOT_CA_PATH, (String)FilePathUtils.getCanonicalPath(xmlFile), (String)FilePathUtils.getCanonicalPath(crlFile), (String)FilePathUtils.getCanonicalPath(cmsFile));
    }
}

