/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.framework.pubservice.entity;

import com.huawei.ism.tool.framework.platform.util.LanguageManager;
import com.huawei.ism.tool.framework.pubservice.resource.PublicServiceResource;

public enum SupportUserRight {
    HWENGINEER("1001"),
    CHANNEL("1002"),
    CUSTOMER("1003"),
    GUEST("1004");

    private static final String PRE_NAME = "rightcontrol.user.right.";
    private String name = "";

    private SupportUserRight(String rightNumber) {
        if ("1001".equals(rightNumber)) {
            this.name = "1001";
        } else if ("1002".equals(rightNumber)) {
            this.name = "1002";
        } else if ("1003".equals(rightNumber)) {
            this.name = "1003";
        } else if ("1004".equals(rightNumber)) {
            this.name = "1004";
        }
    }

    public String getName() {
        return this.name;
    }

    public static SupportUserRight getRight(String rightName) {
        if (rightName.equals(HWENGINEER.getShowName())) {
            return HWENGINEER;
        }
        if (rightName.equals(CHANNEL.getShowName())) {
            return CHANNEL;
        }
        if (rightName.equals(CUSTOMER.getShowName())) {
            return CUSTOMER;
        }
        if (rightName.equals(GUEST.getShowName())) {
            return GUEST;
        }
        return null;
    }

    public static SupportUserRight getUserRight(String rightNumber) {
        if (HWENGINEER.getName().equals(rightNumber)) {
            return HWENGINEER;
        }
        if (CHANNEL.getName().equals(rightNumber)) {
            return CHANNEL;
        }
        if (CUSTOMER.getName().equals(rightNumber)) {
            return CUSTOMER;
        }
        if (GUEST.getName().equals(rightNumber)) {
            return GUEST;
        }
        return GUEST;
    }

    public String getShowName() {
        return PublicServiceResource.getInstance().getString(LanguageManager.getInstance().getCurrentLanguage(), PRE_NAME + this.name);
    }

    public static String getAuthenticateName(SupportUserRight supportUserRight, boolean isLoginByQrImage) {
        if (supportUserRight == null || GUEST.equals((Object)supportUserRight)) {
            if (isLoginByQrImage) {
                return PublicServiceResource.getInstance().getString(LanguageManager.getInstance().getCurrentLanguage(), "rightcontrol.user.right.1004");
            }
            return PublicServiceResource.getInstance().getString(LanguageManager.getInstance().getCurrentLanguage(), "rightcontrol.user.right.offline.authenticated");
        }
        return PublicServiceResource.getInstance().getString(LanguageManager.getInstance().getCurrentLanguage(), "rightcontrol.user.right.online.authenticated");
    }

    public static String getAuthenticateTips(SupportUserRight supportUserRight, boolean isLoginByQrImage) {
        if (supportUserRight == null || GUEST.equals((Object)supportUserRight)) {
            if (isLoginByQrImage) {
                return PublicServiceResource.getInstance().getString(LanguageManager.getInstance().getCurrentLanguage(), "rightcontrol.user.right.1004.tip");
            }
            return PublicServiceResource.getInstance().getString(LanguageManager.getInstance().getCurrentLanguage(), "rightcontrol.user.right.offline.authenticated.tip");
        }
        return PublicServiceResource.getInstance().getString(LanguageManager.getInstance().getCurrentLanguage(), "rightcontrol.user.right.online.authenticated.tip");
    }
}

