/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.tool.framwork.util.func;

import com.huawei.ism.tool.base.utils.reflection.ReflectionUtils;
import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import org.slf4j.Logger;

public class ParamsCheckUtils {
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(ParamsCheckUtils.class);

    public static <T, P extends Annotation> T checkParamsIfAllOk(Object checkObj, Class<P> markerAnno, Object ... params) {
        Method[] methods = checkObj.getClass().getDeclaredMethods();
        for (int i = 0; i < methods.length; ++i) {
            P anno = methods[i].getAnnotation(markerAnno);
            if (anno == null) continue;
            try {
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info("set result:" + ReflectionUtils.setMethodAccessable(methods[i]));
                }
                Object result = methods[i].invoke(checkObj, params);
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info("check :" + checkObj.getClass() + " method :" + methods[i].getName() + " result :" + result);
                }
                if (!(result instanceof Boolean) || ((Boolean)result).booleanValue()) continue;
                return (T)result;
            }
            catch (RuntimeException e) {
                LOGGER.error("exec param check error!", (Throwable)e);
                continue;
            }
            catch (Exception e) {
                LOGGER.error("exec param check error!", (Throwable)e);
            }
        }
        return (T)Boolean.TRUE;
    }
}

