/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.smartkit.drop.util.file;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.IntStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.poifs.filesystem.FileMagic;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.DataFormatter;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ExcelUtils {
    private static final Logger log = LoggerFactory.getLogger(ExcelUtils.class);
    private static final int DEFAULT_EXCEL_FILE_SIZE = 0x10000000;
    private static final DataFormatter DATA_FORMATTER = new DataFormatter();

    public static boolean isExcelFileFormatValid(@NotNull InputStream excelInputStream) {
        try {
            FileMagic excelFileMagic = FileMagic.valueOf((InputStream)excelInputStream);
            return FileMagic.OLE2.equals((Object)excelFileMagic) || FileMagic.OOXML.equals((Object)excelFileMagic);
        }
        catch (IOException exception) {
            log.error("valid excel file format error", (Throwable)exception);
            return false;
        }
    }

    public static boolean isExcelFileSizeValid(@NotNull File excelFile) {
        return FileUtils.sizeOf((File)excelFile) < 0x10000000L;
    }

    public static List<Map<String, String>> readTitleValuePairsBySingleSheet(@NotNull Sheet sheet, int titleRowNum, int valueStartRowNum, int valueEndRowNum) {
        Row titleRow = sheet.getRow(titleRowNum);
        if (ExcelUtils.isEmptyRow(titleRow)) {
            log.warn("current title row is empty,skip parse");
            return Collections.emptyList();
        }
        LinkedList<Map<String, String>> titleValuePairs = new LinkedList<Map<String, String>>();
        for (int valueIndex = valueStartRowNum; valueIndex < valueEndRowNum; ++valueIndex) {
            Row valueRow = sheet.getRow(valueIndex);
            if (ExcelUtils.isEmptyRow(valueRow)) {
                log.info("current value row [{}] is empty,skip", (Object)valueIndex);
                continue;
            }
            HashMap<String, String> titleValuePair = new HashMap<String, String>();
            int lastCellNum = valueRow.getLastCellNum();
            for (int colIndex = 0; colIndex < lastCellNum; ++colIndex) {
                String title = ExcelUtils.getStringFromDiffTypeCell(titleRow.getCell(colIndex));
                String value = ExcelUtils.getStringFromDiffTypeCell(valueRow.getCell(colIndex));
                titleValuePair.put(title, value);
            }
            titleValuePairs.add(titleValuePair);
        }
        return titleValuePairs;
    }

    public static boolean isEmptyRow(Row row) {
        if (row == null) {
            return true;
        }
        return IntStream.range(0, row.getLastCellNum()).mapToObj(arg_0 -> ((Row)row).getCell(arg_0)).allMatch(cell -> Objects.isNull(cell) || StringUtils.isEmpty((CharSequence)ExcelUtils.getStringFromDiffTypeCell(cell)));
    }

    public static String getStringFromDiffTypeCell(Cell cell) {
        CellType cellType = cell.getCellType();
        if (cellType == CellType.STRING) {
            return cell.getStringCellValue();
        }
        return DATA_FORMATTER.formatCellValue(cell);
    }

    private ExcelUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

