/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.service.common;

import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ToolThreadFactory
implements ThreadFactory {
    private static final Logger log = LoggerFactory.getLogger(ToolThreadFactory.class);
    private static final ToolThreadFactory DEFAULT = new ToolThreadFactory(null, "DEFAULT-");
    private final AtomicInteger threadCounter = new AtomicInteger(0);
    private final ThreadGroup group;
    private final String defaultName;

    public ToolThreadFactory(ThreadGroup group, String defaultName) {
        this.group = group;
        this.defaultName = defaultName;
    }

    public ToolThreadFactory(String defaultName) {
        this(null, defaultName);
    }

    @Override
    public Thread newThread(@NotNull Runnable runnable) {
        Thread thread = new Thread(this.group, runnable, this.defaultName + this.threadCounter.incrementAndGet(), 0L);
        thread.setUncaughtExceptionHandler((thisThread, throwable) -> log.error("uncaught exception in thread {}", (Object)thisThread.getName(), (Object)throwable));
        log.info("create new thread with default name: {}, group: {}", (Object)this.defaultName, (Object)this.group);
        return thread;
    }

    public static Thread newDefaultThread(Runnable runnable) {
        return DEFAULT.newThread(runnable);
    }

    public static Thread newDefaultThread(Runnable runnable, String name) {
        Thread thread = DEFAULT.newThread(runnable);
        thread.setName(name);
        return thread;
    }
}

