/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.service.common.entity;

import com.huawei.ism.tool.service.common.ITaskDetail;
import com.huawei.ism.tool.service.rest.model.enumz.Status;
import java.util.Observable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class TaskDetail
extends Observable
implements ITaskDetail {
    private static final Logger log = LoggerFactory.getLogger(TaskDetail.class);
    protected int pro;
    protected Status status = Status.WAITING;
    protected String description;
    protected String suggestion;
    protected boolean changed;

    protected void update() {
        if (!this.changed) {
            return;
        }
        this.changed = false;
        log.info(" {} update pro: {} status: {} description: {} .", new Object[]{this.getClass().getName(), this.pro, this.status, this.description});
        this.setChanged();
        this.notifyObservers(this);
    }

    @Override
    public int getProgress() {
        return this.pro;
    }

    @Override
    public Status getStatus() {
        return this.status;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getSuggestion() {
        return this.suggestion;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isFinished() {
        if (this.status == Status.SUCCESS) return true;
        if (this.status == Status.FAILED) return true;
        if (this.status != Status.PART_SUCCESS) return false;
        return true;
    }

    public boolean isFailed() {
        return Status.FAILED.equals((Object)this.status);
    }

    public boolean isSuccess() {
        return this.status == Status.SUCCESS;
    }

    public boolean isRunning() {
        return this.status == Status.RUNNING;
    }
}

