/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.service.patch.dstorage.ui;

import com.huawei.ism.tool.framework.pubservice.entity.TaskResult;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.entity.KeyValue;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.tool.obase.utils.UiMethod;
import com.huawei.ism.tool.service.patch.dstorage.entity.DstoragePatchInfo;
import com.huawei.ism.tool.service.patch.dstorage.ui.action.ImportAction;
import com.huawei.ism.tool.service.patch.dstorage.ui.action.SelectPatchAction;
import com.huawei.ism.tool.service.patch.service.IHandler;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import com.huawei.ism.ui.swing.dialog.WarningDialog;
import com.huawei.ism.util.UCD;
import java.awt.Component;
import java.awt.Window;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;

public class PatchComponent {
    private TitledBorder title = BorderFactory.createTitledBorder("");
    private JLabel desc = new JLabel(ResourceUtil.getString("patch.ui.desc"));
    private JLabel patchDesc = new JLabel(ResourceUtil.getString("patch.ui.selectpatch.desc"));
    private JTextField pathField = new JTextField("");
    private JButton select = UiMethod.createButton(ResourceUtil.getString("patch.ui.selectpatch.button.desc"));
    private JButton upload = UiMethod.createButton(ResourceUtil.getString("patch.ui.uploadpatch"));
    private DevNode currentNode;
    private JComponent component = null;
    private ImportAction importAction = new ImportAction(this);
    private Window parent;
    private IHandler<TaskResult> postHandler;
    private boolean showBorder;
    private List<DstoragePatchInfo.Type> supportTypeList;
    private Map<DevNode, KeyValue<DstoragePatchInfo, Boolean>> uploadMap = new HashMap<DevNode, KeyValue<DstoragePatchInfo, Boolean>>();

    public PatchComponent(Window parent, List<DstoragePatchInfo.Type> supportType) {
        this(parent, supportType, true);
    }

    public PatchComponent(Window parent, List<DstoragePatchInfo.Type> supportType, boolean showBorder) {
        this.parent = parent;
        this.showBorder = showBorder;
        this.supportTypeList = supportType;
        this.init();
        this.bindListener();
    }

    private void bindListener() {
        this.upload.addActionListener(this.importAction);
        this.select.addActionListener(new SelectPatchAction(this));
    }

    private void init() {
        this.pathField.setEditable(false);
        this.pathField.setHorizontalAlignment(2);
        this.pathField.setCaretPosition(0);
        this.upload.setEnabled(false);
        Box box = UCD.buildHBoxLeft((Component[])new Component[]{this.patchDesc, Box.createHorizontalStrut(0), this.pathField, this.select, this.upload});
        this.component = UiMethod.buildFrameSpace(UCD.buildVerticalBox(null, (Component[])new Component[]{UCD.buildHBoxLeft((Component[])new Component[]{this.desc}), box}), 5);
        if (this.showBorder) {
            this.component.setBorder(this.title);
        }
    }

    public Map<DevNode, KeyValue<DstoragePatchInfo, Boolean>> getUploadMap() {
        return this.uploadMap;
    }

    private void changeTitleDes(DevNode node) {
        this.title.setTitle(ResourceUtil.getStringWithParams("patch.ui.titleborder", node.getIp()));
    }

    private void changePatchField(DevNode node) {
        DstoragePatchInfo patch = this.uploadMap.getOrDefault(node, new KeyValue<Object, Object>(null, null)).getKey();
        this.pathField.setText("");
        this.pathField.setToolTipText("");
        this.upload.setEnabled(false);
        if (null != patch) {
            this.pathField.setText(patch.getPatchPath());
            this.pathField.setToolTipText(patch.getPatchPath());
            this.upload.setEnabled(true);
        }
    }

    public DevNode getCurrentNode() {
        return this.currentNode;
    }

    public JButton getSelect() {
        return this.select;
    }

    public void setCurrentNode(DevNode node) {
        this.currentNode = node;
        this.changePatchField(node);
        if (this.showBorder) {
            this.changeTitleDes(node);
        }
    }

    public DstoragePatchInfo getCurrentPatch() {
        return this.uploadMap.get(this.currentNode).getKey();
    }

    public boolean leaveCheck() {
        KeyValue<DstoragePatchInfo, Boolean> kv = this.uploadMap.get(this.currentNode);
        if (kv == null || kv.getValue() != null) {
            return true;
        }
        WarningDialog warningDialog = DialogUtils.createYesAndNoDialog((JDialog)((JDialog)this.parent), (String)ResourceUtil.getString("patch.ui.leave.checker.waring"));
        if (0 == warningDialog.getValue()) {
            this.importAction.importAction();
            return false;
        }
        return true;
    }

    public TitledBorder getTitle() {
        return this.title;
    }

    public JLabel getDesc() {
        return this.desc;
    }

    public JTextField getPathField() {
        return this.pathField;
    }

    public JButton getUpload() {
        return this.upload;
    }

    public JComponent getComponent() {
        return this.component;
    }

    public Window getParentWindow() {
        return this.parent;
    }

    public PatchComponent setPostHandler(IHandler handler) {
        this.postHandler = handler;
        return this;
    }

    public IHandler<TaskResult> getPostHandler() {
        return this.postHandler;
    }

    public List<DstoragePatchInfo.Type> getSupportTypeList() {
        return this.supportTypeList;
    }
}

