/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.service.patch.dstorage.ui.action;

import com.huawei.ism.tool.obase.entity.KeyValue;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.filechooser.ToolFileChooser;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.tool.service.patch.dstorage.Context;
import com.huawei.ism.tool.service.patch.dstorage.entity.DstoragePatchInfo;
import com.huawei.ism.tool.service.patch.dstorage.ui.PatchComponent;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Locale;
import javax.swing.JTextField;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import utils.FilesUtil;

public class SelectPatchAction
implements ActionListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(SelectPatchAction.class);
    private static final String EXTS = Context.INS.getConfig().getString("patch.file.suffix");
    private static final String TITTLE_DES = ResourceUtil.getString("patch.ui.selectpatch.tittle");
    private static int sizeLimit = 5;
    private PatchComponent component;

    public SelectPatchAction(PatchComponent component) {
        try {
            sizeLimit = Integer.valueOf(Context.INS.getConfig().getString("patch.file.size.limit"));
        }
        catch (Exception e) {
            LOGGER.warn("Init file limit error.use default value");
        }
        LOGGER.info("Init patch file limit : {} mb", (Object)sizeLimit);
        this.component = component;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        HashMap<String, String> extParams = new HashMap<String, String>();
        extParams.put("description", EXTS);
        extParams.put("title", TITTLE_DES);
        extParams.put("PathId", "dstorage.patch.path");
        File selectFile = ToolFileChooser.selectFile(this.component.getParentWindow(), EXTS.split(";"), 0, true, extParams);
        if (null == selectFile) {
            LOGGER.warn("Select file is null.");
            return;
        }
        String path = this.getFilePathAndCheck(selectFile);
        if (path == null) {
            return;
        }
        try {
            DstoragePatchInfo patch = this.checkAndParse(selectFile);
            JTextField field = this.component.getPathField();
            field.setText(path);
            field.setToolTipText(path);
            field.setCaretPosition(0);
            this.component.getUpload().setEnabled(true);
            KeyValue<DstoragePatchInfo, Object> keyValue = new KeyValue<DstoragePatchInfo, Object>(patch, null);
            this.component.getUploadMap().put(this.component.getCurrentNode(), keyValue);
        }
        catch (ToolException ex) {
            LOGGER.error(ex.getLocalizedMessage(), ex.getCause());
            DialogUtils.showErrorDialog((Window)this.component.getParentWindow(), (String)ex.getErrorLocaleDescription());
            return;
        }
        catch (Exception ex) {
            LOGGER.error("Set file path error.", (Throwable)ex);
            DialogUtils.showErrorDialog((Window)this.component.getParentWindow(), (String)ResourceUtil.getString("patch.import.check.invalid"));
            return;
        }
    }

    private String getFilePathAndCheck(File selectFile) {
        String path;
        try {
            path = selectFile.getCanonicalPath();
        }
        catch (IOException ex) {
            DialogUtils.showErrorDialog((Window)this.component.getParentWindow(), (String)ResourceUtil.getString("patch.import.check.invalid"));
            return null;
        }
        if (!FilesUtil.checkNormalPath(path)) {
            DialogUtils.showInfoDialog((Window)this.component.getParentWindow(), (String)ResourceUtil.getString("inspect.path.check"));
            return null;
        }
        return path;
    }

    private DstoragePatchInfo checkAndParse(File selectFile) throws ToolException {
        if (selectFile.length() > (long)(sizeLimit * 1024 * 1024)) {
            throw new ToolException("patch.file.size.oversize", new Object[]{sizeLimit});
        }
        return this.parsePatchFile(selectFile);
    }

    private DstoragePatchInfo parsePatchFile(File selectFile) throws ToolException {
        String fileName = selectFile.getName().toUpperCase(Locale.ENGLISH);
        DstoragePatchInfo patch = new DstoragePatchInfo();
        try {
            patch.setType(DstoragePatchInfo.Type.valueOf(fileName.split("_")[0])).setPatchPath(selectFile.getCanonicalPath());
        }
        catch (Exception e) {
            LOGGER.error("Parse patch type error. file name : {}", (Object)fileName);
        }
        if (!this.component.getSupportTypeList().contains((Object)patch.getType())) {
            throw new ToolException("patch.invalid.type");
        }
        return patch;
    }
}

