/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.smartkit.drop.protocol.ssh.entity;

import com.huawei.smartkit.drop.util.StreamUtils;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.Flushable;
import java.nio.charset.StandardCharsets;

public class CmdResultBuffer {
    private static final char BACKUP = '\b';
    private ByteArrayOutputStream stdoutSB = new ByteArrayOutputStream();
    private ByteArrayOutputStream stderrSB = new ByteArrayOutputStream();
    private final Object lock = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void appendStdout(byte[] curOutArray) {
        int len = curOutArray.length;
        if (len < 1) {
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            this.stdoutSB.write(curOutArray, 0, len);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void appendStderr(byte[] curErrArray) {
        Object object = this.lock;
        synchronized (object) {
            this.stderrSB.write(curErrArray, 0, curErrArray.length);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getStdoutResult(boolean isFlush) {
        Object object = this.lock;
        synchronized (object) {
            String temp = new String(this.stdoutSB.toByteArray(), 0, this.stdoutSB.size(), StandardCharsets.UTF_8);
            StringBuilder sb = this.clearBackChar(temp);
            if (isFlush) {
                this.stdoutSB = new ByteArrayOutputStream();
            }
            return sb.toString();
        }
    }

    private StringBuilder clearBackChar(String temp) {
        StringBuilder sb = new StringBuilder();
        for (int index = 0; index < temp.length(); ++index) {
            char currentChar = temp.charAt(index);
            if (currentChar == '\b' && sb.length() > 0) {
                sb.deleteCharAt(sb.length() - 1);
                continue;
            }
            sb.append(currentChar);
        }
        return sb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getStderrResult(boolean isFlush) {
        Object object = this.lock;
        synchronized (object) {
            String temp = new String(this.stderrSB.toByteArray(), 0, this.stderrSB.size(), StandardCharsets.UTF_8);
            StringBuilder sb = this.clearBackChar(temp);
            if (isFlush) {
                this.stderrSB = new ByteArrayOutputStream();
            }
            return sb.toString();
        }
    }

    public void close() {
        StreamUtils.closeResource((Flushable)this.stderrSB, (Closeable)this.stderrSB);
        StreamUtils.closeResource((Flushable)this.stdoutSB, (Closeable)this.stdoutSB);
    }
}

