/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.smartkit.drop.protocol.ssh.entity;

import java.util.Arrays;
import lombok.Generated;

public enum DeviceType {
    COMPUTE_STORAGE("storage", "compute"),
    FLASH_STORAGE("storage", "flash"),
    SCALE_OUT_STORAGE("storage", "scaleout"),
    WINDOWS_HOST("host", "windows"),
    LINUX_HOST("host", "linux"),
    SOLARIS_HOST("host", "solaris"),
    ESXI_HOST("host", "esxi"),
    FUSION_COMPUTE_HOST("host", "fc"),
    HYPERV_HOST("host", "hyperv");

    private static final String STORAGE = "storage";
    private static final String HOST = "host";
    private final String domain;
    private final String type;

    private DeviceType(String domain, String type) {
        this.domain = domain;
        this.type = type;
    }

    public boolean isStorageDevice() {
        return STORAGE.equals(this.domain);
    }

    public boolean isHostDevice() {
        return HOST.equals(this.domain);
    }

    public static DeviceType convertDeviceType(String domain, String type) {
        return Arrays.stream(DeviceType.values()).filter(deviceType -> deviceType.getDomain().equals(domain) && deviceType.getType().equals(type)).findFirst().orElse(FLASH_STORAGE);
    }

    @Generated
    public String getDomain() {
        return this.domain;
    }

    @Generated
    public String getType() {
        return this.type;
    }
}

