/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.smartkit.drop.protocol.ssh.entity;

import java.net.SocketAddress;
import java.security.PublicKey;
import lombok.Generated;
import org.apache.sshd.client.config.hosts.KnownHostEntry;
import org.apache.sshd.client.keyverifier.ServerKeyVerifier;
import org.apache.sshd.client.session.ClientSession;
import org.apache.sshd.common.config.keys.AuthorizedKeyEntry;
import org.apache.sshd.common.config.keys.KeyUtils;
import org.apache.sshd.common.config.keys.PublicKeyEntryResolver;
import org.apache.sshd.common.session.SessionContext;
import org.apache.sshd.common.util.ValidateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalServerKeyVerifier
implements ServerKeyVerifier {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LocalServerKeyVerifier.class);
    private final String localPublicKeyLine;

    public LocalServerKeyVerifier(String localPublicKeyLine) {
        this.localPublicKeyLine = localPublicKeyLine;
    }

    public boolean verifyServerKey(ClientSession clientSession, SocketAddress remoteAddress, PublicKey serverKey) {
        KnownHostEntry knownHostEntry = KnownHostEntry.parseKnownHostEntry((String)this.localPublicKeyLine);
        if (knownHostEntry != null) {
            AuthorizedKeyEntry authEntry = (AuthorizedKeyEntry)ValidateUtils.checkNotNull((Object)knownHostEntry.getKeyEntry(), (String)"No key extracted from %s", (Object)knownHostEntry);
            PublicKey localPublicKey = authEntry.resolvePublicKey((SessionContext)clientSession, PublicKeyEntryResolver.IGNORING);
            return KeyUtils.compareKeys((PublicKey)localPublicKey, (PublicKey)serverKey);
        }
        log.warn("the local PublicKey is invalid.");
        return false;
    }
}

