/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.smartkit.drop.protocol.ssh.entity;

import com.huawei.smartkit.drop.protocol.ssh.entity.CmdResultBuffer;
import com.huawei.smartkit.drop.util.StreamUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.EnumSet;
import java.util.concurrent.TimeUnit;
import org.apache.sshd.client.channel.ChannelShell;
import org.apache.sshd.client.channel.ClientChannelEvent;
import org.apache.sshd.client.session.ClientSession;
import org.apache.sshd.common.future.CancelOption;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SessionMonitor {
    private static final Logger LOGGER = LoggerFactory.getLogger(SessionMonitor.class);
    private static final int CHANNEL_OPEN_TIME_OUT = 30;
    private static final long OUTPUT_COMPLETE_TIMEOUT = 10L;
    private final PipedOutputStream pos = new PipedOutputStream();
    private final ByteArrayOutputStream stdout = new ByteArrayOutputStream();
    private final ByteArrayOutputStream stderr = new ByteArrayOutputStream();
    private PipedInputStream pis = null;
    private CmdResultBuffer cmdRequest = null;
    private ClientSession session = null;
    private OutputStream stdin = null;
    private ChannelShell shellChannel = null;
    private volatile boolean active = true;

    public SessionMonitor(ClientSession session) {
        this.session = session;
    }

    public void startShell() throws IOException {
        this.pis = new PipedInputStream(this.pos);
        this.cmdRequest = new CmdResultBuffer();
        this.shellChannel = this.session.createShellChannel();
        this.shellChannel.setPtyType("bash");
        this.shellChannel.setUsePty(true);
        this.shellChannel.setIn((InputStream)this.pis);
        this.shellChannel.setOut((OutputStream)this.stdout);
        this.shellChannel.setErr((OutputStream)this.stderr);
        this.shellChannel.open().verify(30L, TimeUnit.SECONDS, new CancelOption[0]);
        this.stdin = this.shellChannel.getInvertedIn();
    }

    public boolean isActive() {
        return this.active;
    }

    public void sendCmd(String cmd) throws IOException {
        this.stdin.write(cmd.getBytes(StandardCharsets.UTF_8));
        this.stdin.flush();
        this.shellChannel.waitFor(EnumSet.of(ClientChannelEvent.OPENED), Duration.ofSeconds(10L));
    }

    public void sendCmd(int cmd) throws IOException {
        this.stdin.write(cmd);
        this.stdin.flush();
        this.shellChannel.waitFor(EnumSet.of(ClientChannelEvent.OPENED), Duration.ofSeconds(10L));
    }

    public String getCurrentStdOut(boolean isFlush) {
        if (this.isOver()) {
            return this.cmdRequest.getStdoutResult(isFlush);
        }
        try {
            this.cmdRequest.appendStdout(this.getStdString(this.stdout));
        }
        catch (IOException e) {
            LOGGER.error("get standard out error.", (Throwable)e);
        }
        return this.cmdRequest.getStdoutResult(isFlush);
    }

    public String getCurrentStdErr(boolean isFlush) {
        if (this.isOver()) {
            return this.cmdRequest.getStderrResult(isFlush);
        }
        try {
            this.cmdRequest.appendStderr(this.getStdString(this.stderr));
        }
        catch (IOException e) {
            LOGGER.error("get error out error.", (Throwable)e);
        }
        return this.cmdRequest.getStderrResult(isFlush);
    }

    public void close() {
        this.active = false;
        StreamUtils.closeStream((OutputStream)this.stdin, null);
        StreamUtils.closeStream((OutputStream)this.stdout, null);
        StreamUtils.closeStream((OutputStream)this.stderr, null);
        StreamUtils.closeStream(null, (InputStream)this.pis);
        StreamUtils.closeStream((OutputStream)this.pos, null);
        this.cmdRequest.close();
        try {
            this.shellChannel.close();
        }
        catch (IOException e) {
            LOGGER.error("close shell channel error.", (Throwable)e);
        }
        try {
            this.session.close();
        }
        catch (IOException e) {
            LOGGER.error("close session error.", (Throwable)e);
        }
    }

    private boolean isOver() {
        if (this.shellChannel.isEofSent() || this.shellChannel.isEofSignalled() || this.shellChannel.isClosed()) {
            LOGGER.error("It seems EOF or EXIT_SIGNAL happened!!");
            return true;
        }
        return false;
    }

    private byte[] getStdString(ByteArrayOutputStream result) throws IOException {
        byte[] content = result.toByteArray();
        result.reset();
        return content;
    }
}

